/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.slf4j.Logger;

public abstract class AbstractServerFactory
implements Configurable,
LogEnabled {
    private Logger log;
    private List<AbstractConfigurableAsyncServer> servers;
    private HierarchicalConfiguration config;

    protected abstract List<AbstractConfigurableAsyncServer> createServers(Logger var1, HierarchicalConfiguration var2) throws Exception;

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.config = config;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    @PostConstruct
    public void init() throws Exception {
        this.servers = this.createServers(this.log, this.config);
        for (AbstractConfigurableAsyncServer server : this.servers) {
            server.init();
        }
    }

    public List<AbstractConfigurableAsyncServer> getServers() {
        return this.servers;
    }

    @PreDestroy
    public void destroy() {
        for (AbstractConfigurableAsyncServer server : this.servers) {
            server.destroy();
        }
    }
}

