/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lib.jmx.LineHandlerStats;

public abstract class AbstractLineHandlerResultJMXMonitor<R extends Response, S extends ProtocolSession>
implements ProtocolHandlerResultHandler<R, S>,
ExtensibleHandler,
ProtocolHandler {
    private final Map<String, LineHandlerStats> lStats = new HashMap<String, LineHandlerStats>();
    private String jmxName;

    public Response onResponse(ProtocolSession session, Response response, long executionTime, ProtocolHandler handler) {
        if (handler instanceof LineHandler) {
            this.lStats.get(handler.getClass().getName()).increment(response);
        }
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(LineHandler.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(LineHandler.class)) {
            for (Object anExtension : extension) {
                LineHandler c = (LineHandler)anExtension;
                if (this.equals(c)) continue;
                String cName = c.getClass().getName();
                try {
                    this.lStats.put(cName, new LineHandlerStats(this.jmxName, cName));
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    public void init(Configuration config) throws ConfigurationException {
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
    }

    public void destroy() {
        for (LineHandlerStats lineHandlerStats : this.lStats.values()) {
            lineHandlerStats.dispose();
        }
    }

    protected abstract String getDefaultJMXName();
}

