/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;

public class ProtocolHandlerChainImpl
implements ProtocolHandlerChain {
    private final ProtocolHandlerLoader loader;
    private final HierarchicalConfiguration handlerchainConfig;
    private final String jmxName;
    private final String coreHandlersPackage;
    private final String jmxHandlersPackage;
    private final List<Object> handlers = new LinkedList<Object>();

    public ProtocolHandlerChainImpl(ProtocolHandlerLoader loader, HierarchicalConfiguration handlerchainConfig, String jmxName, Class<? extends HandlersPackage> coreHandlersPackage, Class<? extends HandlersPackage> jmxHandlersPackage) {
        this.loader = loader;
        this.handlerchainConfig = handlerchainConfig;
        this.jmxName = jmxName;
        this.coreHandlersPackage = coreHandlersPackage.getName();
        this.jmxHandlersPackage = jmxHandlersPackage.getName();
    }

    public void init() throws Exception {
        List children = this.handlerchainConfig.configurationsAt("handler");
        if (this.handlerchainConfig.getString("[@coreHandlersPackage]") == null) {
            this.handlerchainConfig.addProperty("[@coreHandlersPackage]", (Object)this.coreHandlersPackage);
        }
        String coreHandlersPackage = this.handlerchainConfig.getString("[@coreHandlersPackage]");
        if (this.handlerchainConfig.getString("[@jmxHandlersPackage]") == null) {
            this.handlerchainConfig.addProperty("[@jmxHandlersPackage]", (Object)this.jmxHandlersPackage);
        }
        String jmxHandlersPackage = this.handlerchainConfig.getString("[@jmxHandlersPackage]");
        HandlersPackage handlersPackage = (HandlersPackage)this.loader.load(coreHandlersPackage, (Configuration)this.addHandler(coreHandlersPackage));
        this.registerHandlersPackage(handlersPackage, null, children);
        if (this.handlerchainConfig.getBoolean("[@enableJmx]", true)) {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            builder.addProperty("jmxName", (Object)this.jmxName);
            HandlersPackage jmxPackage = (HandlersPackage)this.loader.load(jmxHandlersPackage, (Configuration)this.addHandler(jmxHandlersPackage));
            this.registerHandlersPackage(jmxPackage, (HierarchicalConfiguration)builder, children);
        }
        for (HierarchicalConfiguration hConf : children) {
            String className = hConf.getString("[@class]", null);
            if (className != null) {
                this.handlers.add(this.loader.load(className, (Configuration)hConf));
                continue;
            }
            throw new ConfigurationException("Missing @class attribute in configuration: " + ConfigurationUtils.toString((Configuration)hConf));
        }
        this.wireExtensibleHandlers();
    }

    private void wireExtensibleHandlers() throws WiringException {
        LinkedList<ExtensibleHandler> eHandlers = this.getHandlers(ExtensibleHandler.class);
        for (ExtensibleHandler extensibleHandler : eHandlers) {
            List markerInterfaces = extensibleHandler.getMarkerInterfaces();
            for (Class markerInterface : markerInterfaces) {
                LinkedList extensions = this.getHandlers(markerInterface);
                extensibleHandler.wireExtensions(markerInterface, extensions);
            }
        }
    }

    private void registerHandlersPackage(HandlersPackage handlersPackage, HierarchicalConfiguration handlerConfig, List<HierarchicalConfiguration> children) throws ConfigurationException {
        List<String> c = handlersPackage.getHandlers();
        for (String cName : c) {
            try {
                CombinedConfiguration conf = new CombinedConfiguration();
                HierarchicalConfiguration cmdConf = this.addHandler(cName);
                conf.addConfiguration((AbstractConfiguration)cmdConf);
                if (handlerConfig != null) {
                    conf.addConfiguration((AbstractConfiguration)handlerConfig);
                }
                children.add((HierarchicalConfiguration)conf);
            }
            catch (ConfigurationException e) {
                throw new ConfigurationException("Unable to create configuration for handler " + cName, (Throwable)e);
            }
        }
    }

    private HierarchicalConfiguration addHandler(String className) throws ConfigurationException {
        DefaultConfigurationBuilder hConf = new DefaultConfigurationBuilder();
        hConf.addProperty("[@class]", (Object)className);
        return hConf;
    }

    public <T> LinkedList<T> getHandlers(Class<T> type) {
        LinkedList<Object> hList = new LinkedList<Object>();
        for (Object h : this.handlers) {
            if (!type.isInstance(h)) continue;
            hList.add(h);
        }
        return hList;
    }

    public void destroy() {
        LinkedList<ProtocolHandler> lHandlers = this.getHandlers(ProtocolHandler.class);
        for (ProtocolHandler handler : lHandlers) {
            handler.destroy();
        }
    }
}

