/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.mailet.MailAddress;

public class PerRecipientHeaders {
    public static final Function<Header, String> GET_HEADER_NAME = new Function<Header, String>(){

        public String apply(Header input) {
            return input.getName();
        }
    };
    private Multimap<MailAddress, Header> headersByRecipient = ArrayListMultimap.create();

    public Collection<MailAddress> getRecipientsWithSpecificHeaders() {
        return this.headersByRecipient.keySet();
    }

    public Collection<Header> getHeadersForRecipient(MailAddress recipient) {
        return this.headersByRecipient.get((Object)recipient);
    }

    public Collection<String> getHeaderNamesForRecipient(MailAddress recipient) {
        return FluentIterable.from((Iterable)this.headersByRecipient.get((Object)recipient)).transform(GET_HEADER_NAME).toSet();
    }

    public void addHeaderForRecipient(Header header, MailAddress recipient) {
        this.headersByRecipient.put((Object)recipient, (Object)header);
    }

    public final boolean equals(Object o) {
        if (o instanceof PerRecipientHeaders) {
            PerRecipientHeaders that = (PerRecipientHeaders)o;
            return Objects.equal(this.headersByRecipient, that.headersByRecipient);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.headersByRecipient});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("headersByRecipient", this.headersByRecipient).toString();
    }

    public static class Header {
        private final String name;
        private final String value;

        public static Builder builder() {
            return new Builder();
        }

        @VisibleForTesting
        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Header) {
                Header that = (Header)o;
                return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.value, (Object)that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.value});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
        }

        public static class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Header build() {
                Preconditions.checkNotNull((Object)this.name);
                Preconditions.checkNotNull((Object)this.value);
                return new Header(this.name, this.value);
            }
        }
    }
}

