/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import java.io.Serializable;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailAddress
implements Serializable {
    public static final long serialVersionUID = 2779163542539434916L;
    private static final char[] SPECIAL = new char[]{'<', '>', '(', ')', '[', ']', '\\', '.', ',', ';', ':', '@', '\"'};
    private String localPart = null;
    private String domain = null;

    private int stripSourceRoute(String address, int pos) {
        int i;
        if (pos < address.length() && address.charAt(pos) == '@' && (i = address.indexOf(58)) != -1) {
            pos = i + 1;
        }
        return pos;
    }

    public MailAddress(String address) throws AddressException {
        address = address.trim();
        int pos = 0;
        this.stripSourceRoute(address, pos);
        StringBuffer localPartSB = new StringBuffer();
        StringBuffer domainSB = new StringBuffer();
        try {
            pos = address.charAt(pos) == '\"' ? this.parseQuotedLocalPartOrThrowException(localPartSB, address, pos) : this.parseUnquotedLocalPartOrThrowException(localPartSB, address, pos);
            if (pos >= address.length() || address.charAt(pos) != '@') {
                throw new AddressException("Did not find @ between local-part and domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            ++pos;
            while ((pos = address.charAt(pos) == '#' ? this.parseNumber(domainSB, address, pos) : (address.charAt(pos) == '[' ? this.parseDomainLiteral(domainSB, address, pos) : this.parseDomain(domainSB, address, pos))) < address.length() && address.charAt(pos) == '.') {
                char lastChar = address.charAt(pos - 1);
                if (lastChar == '@' || lastChar == '.') {
                    throw new AddressException("Subdomain expected before '.' or duplicate '.' in " + address);
                }
                domainSB.append('.');
                ++pos;
            }
            if (domainSB.toString().length() == 0) {
                throw new AddressException("No domain found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new AddressException("Out of data at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        this.localPart = localPartSB.toString();
        this.domain = domainSB.toString();
    }

    private int parseUnquotedLocalPartOrThrowException(StringBuffer localPartSB, String address, int pos) throws AddressException {
        pos = this.parseUnquotedLocalPart(localPartSB, address, pos);
        if (localPartSB.toString().length() == 0) {
            throw new AddressException("No local-part (user account) found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        return pos;
    }

    private int parseQuotedLocalPartOrThrowException(StringBuffer localPartSB, String address, int pos) throws AddressException {
        pos = this.parseQuotedLocalPart(localPartSB, address, pos);
        if (localPartSB.toString().length() == 2) {
            throw new AddressException("No quoted local-part (user account) found at position " + (pos + 2) + " in '" + address + "'", address, pos + 2);
        }
        return pos;
    }

    public MailAddress(String localPart, String domain) throws AddressException {
        this(new InternetAddress(localPart + "@" + domain));
    }

    public MailAddress(InternetAddress address) throws AddressException {
        this(address.getAddress());
    }

    @Deprecated
    public String getHost() {
        return this.getDomain();
    }

    public String getDomain() {
        if (!this.domain.startsWith("[") || !this.domain.endsWith("]")) {
            return this.domain;
        }
        return this.domain.substring(1, this.domain.length() - 1);
    }

    @Deprecated
    public String getUser() {
        return this.getLocalPart();
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String asString() {
        return this.localPart + "@" + this.domain;
    }

    public String toString() {
        return this.localPart + "@" + this.domain;
    }

    public String asPrettyString() {
        return '<' + this.asString() + '>';
    }

    public InternetAddress toInternetAddress() {
        try {
            return new InternetAddress(this.toString());
        }
        catch (AddressException ae) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String theString = (String)obj;
            return this.toString().equalsIgnoreCase(theString);
        }
        if (obj instanceof MailAddress) {
            MailAddress addr = (MailAddress)obj;
            return this.getLocalPart().equalsIgnoreCase(addr.getLocalPart()) && this.getDomain().equalsIgnoreCase(addr.getDomain());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().toLowerCase(Locale.US).hashCode();
    }

    private int parseQuotedLocalPart(StringBuffer lpSB, String address, int pos) throws AddressException {
        StringBuilder resultSB = new StringBuilder();
        resultSB.append('\"');
        ++pos;
        while (true) {
            if (address.charAt(pos) == '\"') break;
            if (address.charAt(pos) == '\\') {
                resultSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                resultSB.append(x);
                ++pos;
                continue;
            }
            char q = address.charAt(pos);
            if (q <= '\u0000' || q == '\n' || q == '\r' || q == '\"' || q == '\\') {
                throw new AddressException("Unquoted local-part (user account) must be one of the 128 ASCI characters exception <CR>, <LF>, quote (\"), or backslash (\\) at position " + (pos + 1) + " in '" + address + "'");
            }
            resultSB.append(q);
            ++pos;
        }
        resultSB.append('\"');
        lpSB.append((CharSequence)resultSB);
        return ++pos;
    }

    private int parseUnquotedLocalPart(StringBuffer lpSB, String address, int pos) throws AddressException {
        StringBuilder resultSB = new StringBuilder();
        boolean lastCharDot = false;
        while (true) {
            if (address.charAt(pos) == '\\') {
                resultSB.append('\\');
                char x = address.charAt(++pos);
                if (x < '\u0000' || x > '\u007f') {
                    throw new AddressException("Invalid \\ syntaxed character at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                resultSB.append(x);
                ++pos;
                lastCharDot = false;
                continue;
            }
            if (address.charAt(pos) == '.') {
                if (pos == 0) {
                    throw new AddressException("Local part must not start with a '.'");
                }
                resultSB.append('.');
                ++pos;
                lastCharDot = true;
                continue;
            }
            if (address.charAt(pos) == '@') break;
            char c = address.charAt(pos);
            if (c <= '\u001f' || c >= '\u007f' || c == ' ') {
                throw new AddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            for (int i = 0; i < SPECIAL.length; ++i) {
                if (c != SPECIAL[i]) continue;
                throw new AddressException("Invalid character in local-part (user account) at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(c);
            ++pos;
            lastCharDot = false;
        }
        if (lastCharDot) {
            throw new AddressException("local-part (user account) ended with a \".\", which is invalid in address '" + address + "'", address, pos);
        }
        lpSB.append((CharSequence)resultSB);
        return pos;
    }

    private int parseNumber(StringBuffer dSB, String address, int pos) throws AddressException {
        char d;
        StringBuilder resultSB = new StringBuilder();
        resultSB.append(address.charAt(pos));
        ++pos;
        while (pos < address.length() && (d = address.charAt(pos)) != '.') {
            if (d < '0' || d > '9') {
                throw new AddressException("In domain, did not find a number in # address at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(d);
            ++pos;
        }
        if (resultSB.length() < 2) {
            throw new AddressException("In domain, did not find a number in # address at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        dSB.append((CharSequence)resultSB);
        return pos;
    }

    private int parseDomainLiteral(StringBuffer dSB, String address, int pos) throws AddressException {
        StringBuilder resultSB = new StringBuilder();
        resultSB.append(address.charAt(pos));
        ++pos;
        for (int octet = 0; octet < 4; ++octet) {
            char currentChar;
            StringBuilder snumSB = new StringBuilder();
            for (int digits = 0; digits < 3 && (currentChar = address.charAt(pos)) != '.' && currentChar != ']'; ++digits) {
                if (currentChar < '0' || currentChar > '9') {
                    throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
                snumSB.append(currentChar);
                ++pos;
            }
            if (snumSB.toString().length() == 0) {
                throw new AddressException("Number not found at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            try {
                int snum = Integer.parseInt(snumSB.toString());
                if (snum > 255) {
                    throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
                }
            }
            catch (NumberFormatException nfe) {
                throw new AddressException("Invalid number at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            resultSB.append(snumSB.toString());
            if (address.charAt(pos) == ']') {
                if (octet >= 3) break;
                throw new AddressException("End of number reached too quickly at " + (pos + 1) + " in '" + address + "'", address, pos + 1);
            }
            if (address.charAt(pos) != '.') continue;
            resultSB.append('.');
            ++pos;
        }
        if (address.charAt(pos) != ']') {
            throw new AddressException("Did not find closing bracket \"]\" in domain at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        resultSB.append(']');
        dSB.append((CharSequence)resultSB);
        return ++pos;
    }

    private int parseDomain(StringBuffer dSB, String address, int pos) throws AddressException {
        String result;
        StringBuilder resultSB = new StringBuilder();
        while (pos < address.length()) {
            char ch = address.charAt(pos);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-') {
                resultSB.append(ch);
                ++pos;
                continue;
            }
            if (ch == '.') break;
            throw new AddressException("Invalid character at " + pos + " in '" + address + "'", address, pos);
        }
        if ((result = resultSB.toString()).startsWith("-") || result.endsWith("-")) {
            throw new AddressException("Domain name cannot begin or end with a hyphen \"-\" at position " + (pos + 1) + " in '" + address + "'", address, pos + 1);
        }
        dSB.append(result);
        return pos;
    }
}

