/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.math.BigDecimal;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class BigDecimals
extends Numbers<BigDecimal> {
    private static final BigDecimals INSTANCE = new BigDecimals();

    public static BigDecimals instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    BigDecimals() {
    }

    public BigDecimals(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected BigDecimal zero() {
        return BigDecimal.ZERO;
    }

    public void assertIsCloseTo(AssertionInfo info, BigDecimal actual, BigDecimal other, Offset<BigDecimal> offset) {
        BigDecimals.assertNotNull(info, actual);
        BigDecimal differenceAbsoluteValue = this.abs(actual.subtract(other));
        if (differenceAbsoluteValue.subtract((BigDecimal)offset.value).compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, other, offset, differenceAbsoluteValue));
    }

    private BigDecimal abs(BigDecimal bigDecimal) {
        return bigDecimal.signum() < 0 ? bigDecimal.negate() : bigDecimal;
    }
}

