/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.fetchmail.FetchMail;
import org.apache.james.fetchmail.FetchSchedulerMBean;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.concurrent.JMXEnabledScheduledThreadPoolExecutor;
import org.slf4j.Logger;

public class FetchScheduler
implements FetchSchedulerMBean,
LogEnabled,
Configurable {
    private HierarchicalConfiguration conf;
    private volatile boolean enabled = false;
    private final List<ScheduledFuture<?>> schedulers = new ArrayList();
    private DNSService dns;
    private UsersRepository urepos;
    private Logger logger;
    private MailQueueFactory queueFactory;
    private DomainList domainList;

    @Inject
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Inject
    public void setUsersRepository(UsersRepository urepos) {
        this.urepos = urepos;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public final void setLog(Logger logger) {
        this.logger = logger;
    }

    public final void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.conf = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.enabled = this.conf.getBoolean("[@enabled]", false);
        if (this.enabled) {
            int numThreads = this.conf.getInt("threads", 5);
            String jmxName = this.conf.getString("jmxName", "fetchmail");
            String jmxPath = "org.apache.james:type=component,name=" + jmxName + ",sub-type=threadpool";
            JMXEnabledScheduledThreadPoolExecutor scheduler = new JMXEnabledScheduledThreadPoolExecutor(numThreads, jmxPath, "scheduler");
            MailQueue queue = this.queueFactory.getQueue("spool");
            List fetchConfs = this.conf.configurationsAt("fetch");
            for (HierarchicalConfiguration fetchConf : fetchConfs) {
                Long interval = fetchConf.getLong("interval");
                FetchMail fetcher = new FetchMail();
                fetcher.setLog(this.logger);
                fetcher.setDNSService(this.dns);
                fetcher.setUsersRepository(this.urepos);
                fetcher.setMailQueue(queue);
                fetcher.setDomainList(this.domainList);
                fetcher.configure(fetchConf);
                this.schedulers.add(scheduler.scheduleWithFixedDelay(fetcher, 0L, interval, TimeUnit.MILLISECONDS));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("FetchMail Started");
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("FetchMail Disabled");
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.enabled) {
            this.logger.info("FetchMail dispose...");
            for (ScheduledFuture<?> scheduler1 : this.schedulers) {
                scheduler1.cancel(false);
            }
            this.logger.info("FetchMail ...dispose end");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }
}

