/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.util.ArrayList;
import java.util.List;
import javax.mail.Session;
import javax.mail.internet.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.fetchmail.ParsedConfiguration;
import org.apache.mailet.MailAddress;

class Account
implements Comparable<Account> {
    private static final int DEFAULT_INITIAL_SIZE_OF_DEFERRED_RECIPIENT_ARRAY = 16;
    private String fieldPassword;
    private MailAddress fieldRecipient;
    private String fieldUser;
    private ParsedConfiguration fieldParsedConfiguration;
    private List<String> fieldDeferredRecipientNotFoundMessageIDs;
    private int fieldSequenceNumber;
    private boolean fieldIgnoreRecipientHeader;
    private Session fieldSession;
    private String customRecipientHeader;

    private Account() {
    }

    public Account(int sequenceNumber, ParsedConfiguration parsedConfiguration, String user, String password, String recipient, boolean ignoreRecipientHeader, String customRecipientHeader, Session session) throws ConfigurationException {
        this();
        this.setSequenceNumber(sequenceNumber);
        this.setParsedConfiguration(parsedConfiguration);
        this.setUser(user);
        this.setPassword(password);
        this.setRecipient(recipient);
        this.setIgnoreRecipientHeader(ignoreRecipientHeader);
        this.setCustomRecipientHeader(customRecipientHeader);
        this.setSession(session);
    }

    public String getCustomRecipientHeader() {
        return this.customRecipientHeader;
    }

    public String getPassword() {
        return this.fieldPassword;
    }

    public MailAddress getRecipient() {
        return this.fieldRecipient;
    }

    public String getUser() {
        return this.fieldUser;
    }

    public void setCustomRecipientHeader(String customRecipientHeader) {
        this.customRecipientHeader = customRecipientHeader;
    }

    protected void setPassword(String password) {
        this.fieldPassword = password;
    }

    protected void setRecipient(MailAddress recipient) {
        this.fieldRecipient = recipient;
    }

    protected void setRecipient(String recipient) throws ConfigurationException {
        if (null == recipient) {
            this.fieldRecipient = null;
            return;
        }
        try {
            this.setRecipient(new MailAddress(recipient));
        }
        catch (ParseException pe) {
            throw new ConfigurationException("Invalid recipient address specified: " + recipient);
        }
    }

    protected void setUser(String user) {
        this.fieldUser = user;
    }

    protected void setIgnoreRecipientHeader(boolean ignoreRecipientHeader) {
        this.fieldIgnoreRecipientHeader = ignoreRecipientHeader;
    }

    public boolean isIgnoreRecipientHeader() {
        return this.fieldIgnoreRecipientHeader;
    }

    public int getSequenceNumber() {
        return this.fieldSequenceNumber;
    }

    protected void setSequenceNumber(int sequenceNumber) {
        this.fieldSequenceNumber = sequenceNumber;
    }

    @Override
    public int compareTo(Account account) {
        return this.getSequenceNumber() - account.getSequenceNumber();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        return this.getSequenceNumber() == other.getSequenceNumber();
    }

    public int hashCode() {
        return 527 + this.getSequenceNumber();
    }

    public List<String> getDeferredRecipientNotFoundMessageIDs() {
        List<String> messageIDs = this.getDeferredRecipientNotFoundMessageIDsBasic();
        if (null == messageIDs) {
            this.updateDeferredRecipientNotFoundMessageIDs();
            return this.getDeferredRecipientNotFoundMessageIDs();
        }
        return messageIDs;
    }

    private List<String> getDeferredRecipientNotFoundMessageIDsBasic() {
        return this.fieldDeferredRecipientNotFoundMessageIDs;
    }

    protected List<String> computeDeferredRecipientNotFoundMessageIDs() {
        return new ArrayList<String>(16);
    }

    protected void updateDeferredRecipientNotFoundMessageIDs() {
        this.setDeferredRecipientNotFoundMessageIDs(this.computeDeferredRecipientNotFoundMessageIDs());
    }

    protected void setDeferredRecipientNotFoundMessageIDs(List<String> defferedRecipientNotFoundMessageIDs) {
        this.fieldDeferredRecipientNotFoundMessageIDs = defferedRecipientNotFoundMessageIDs;
    }

    public ParsedConfiguration getParsedConfiguration() {
        return this.fieldParsedConfiguration;
    }

    protected void setParsedConfiguration(ParsedConfiguration parsedConfiguration) {
        this.fieldParsedConfiguration = parsedConfiguration;
    }

    public Session getSession() {
        return this.fieldSession;
    }

    protected void setSession(Session session) {
        this.fieldSession = session;
    }
}

