/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.api;

import java.io.InputStream;
import java.util.List;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.joda.time.DateTime;

public interface SieveRepository {
    public static final String NO_SCRIPT_NAME = "";

    public void haveSpace(String var1, String var2, long var3) throws QuotaExceededException, StorageException;

    public void putScript(String var1, String var2, String var3) throws StorageException, QuotaExceededException;

    public List<ScriptSummary> listScripts(String var1) throws StorageException;

    public DateTime getActivationDateForActiveScript(String var1) throws StorageException, ScriptNotFoundException;

    public InputStream getActive(String var1) throws ScriptNotFoundException, StorageException;

    public void setActive(String var1, String var2) throws ScriptNotFoundException, StorageException;

    public InputStream getScript(String var1, String var2) throws ScriptNotFoundException, StorageException;

    public void deleteScript(String var1, String var2) throws ScriptNotFoundException, IsActiveException, StorageException;

    public void renameScript(String var1, String var2, String var3) throws ScriptNotFoundException, DuplicateException, StorageException;

    public boolean hasQuota() throws StorageException;

    public long getQuota() throws QuotaNotFoundException, StorageException;

    public void setQuota(long var1) throws StorageException;

    public void removeQuota() throws QuotaNotFoundException, StorageException;

    public boolean hasQuota(String var1) throws StorageException;

    public long getQuota(String var1) throws QuotaNotFoundException, StorageException;

    public void setQuota(String var1, long var2) throws StorageException;

    public void removeQuota(String var1) throws QuotaNotFoundException, StorageException;
}

