/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lmtp.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lmtp.LMTPMultiResponse;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;

public class DataLineMessageHookHandler
extends org.apache.james.protocols.smtp.core.DataLineMessageHookHandler {
    private final List<DeliverToRecipientHook> handlers = new ArrayList<DeliverToRecipientHook>();

    protected Response processExtensions(SMTPSession session, MailEnvelopeImpl mail) {
        LMTPMultiResponse mResponse = null;
        for (MailAddress recipient : mail.getRecipients()) {
            DeliverToRecipientHook handler;
            SMTPResponse response = null;
            Iterator<DeliverToRecipientHook> iterator = this.handlers.iterator();
            while (iterator.hasNext() && (response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)(handler = iterator.next()).deliver(session, recipient, (MailEnvelope)mail))) == null) {
            }
            if (response == null) {
                response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + "Temporary error deliver message to " + recipient));
            }
            if (mResponse == null) {
                mResponse = new LMTPMultiResponse((Response)response);
                continue;
            }
            mResponse.addResponse((Response)response);
        }
        return mResponse;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList markers = new ArrayList();
        markers.add(DeliverToRecipientHook.class);
        return markers;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (interfaceName.equals(DeliverToRecipientHook.class)) {
            this.handlers.addAll(extension);
        }
    }
}

