/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import com.google.common.base.Optional;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.store.mail.AbstractLockingUidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JCRUidProvider
extends AbstractLockingUidProvider {
    private final MailboxSessionJCRRepository repository;

    public JCRUidProvider(MailboxPathLocker locker, MailboxSessionJCRRepository repository) {
        super(locker);
        this.repository = repository;
    }

    public Optional<MessageUid> lastUid(MailboxSession mailboxSession, Mailbox mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(mailboxSession);
            Node node = s.getNodeByIdentifier(mailbox.getMailboxId().serialize());
            long rawUid = node.getProperty("jamesMailbox:mailboxLastUid").getLong();
            if (rawUid == 0L) {
                return Optional.absent();
            }
            return Optional.of((Object)MessageUid.of((long)rawUid));
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to get last uid for mailbox " + mailbox, (Throwable)e);
        }
    }

    protected MessageUid lockedNextUid(MailboxSession session, Mailbox mailbox) throws MailboxException {
        try {
            Session s = this.repository.login(session);
            Node node = s.getNodeByIdentifier(mailbox.getMailboxId().serialize());
            MessageUid uid = MessageUid.of((long)node.getProperty("jamesMailbox:mailboxLastUid").getLong());
            MessageUid nextUid = uid.next();
            node.setProperty("jamesMailbox:mailboxLastUid", nextUid.asLong());
            s.save();
            return nextUid;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to consume next uid for mailbox " + mailbox, (Throwable)e);
        }
    }
}

