/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.mail.Flags;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.model.JCRMailboxMessage;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.SimpleMessageMetaData;
import org.apache.james.mailbox.store.mail.AbstractMessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.utils.ApplicableFlagCalculator;

public class JCRMessageMapper
extends AbstractMessageMapper
implements JCRImapConstants {
    private static final String XPATH_LANGUAGE = "xpath";
    public static final int MESSAGE_SCALE_NONE = 0;
    public static final int MESSAGE_SCALE_YEAR = 1;
    public static final int MESSAGE_SCALE_MONTH = 2;
    public static final int MESSAGE_SCALE_DAY = 3;
    public static final int MESSAGE_SCALE_HOUR = 4;
    public static final int MESSAGE_SCALE_MINUTE = 5;
    private final int scaleType;
    private final MailboxSessionJCRRepository repository;

    public JCRMessageMapper(MailboxSessionJCRRepository repository, MailboxSession mSession, UidProvider uidProvider, ModSeqProvider modSeqProvider, int scaleType) {
        super(mSession, uidProvider, modSeqProvider);
        this.repository = repository;
        this.scaleType = scaleType;
    }

    public JCRMessageMapper(MailboxSessionJCRRepository repos, MailboxSession session, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        this(repos, session, uidProvider, modSeqProvider, 3);
    }

    protected Session getSession() throws RepositoryException {
        return this.repository.login(this.mailboxSession);
    }

    protected void begin() throws MailboxException {
        try {
            this.getSession().refresh(true);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void commit() throws MailboxException {
        try {
            if (this.getSession().hasPendingChanges()) {
                this.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to commit", (Throwable)e);
        }
    }

    protected void rollback() throws MailboxException {
        try {
            this.getSession().refresh(false);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void endRequest() {
        this.repository.logout(this.mailboxSession);
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message) order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator nodes = result.getNodes();
            long count = nodes.getSize();
            if (count == -1L) {
                count = 0L;
                while (nodes.hasNext()) {
                    nodes.nextNode();
                    ++count;
                }
            }
            return count;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to count messages in mailbox " + mailbox, (Throwable)e);
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:seen" + "='false'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator nodes = result.getNodes();
            long count = nodes.getSize();
            if (count == -1L) {
                count = 0L;
                while (nodes.hasNext()) {
                    nodes.nextNode();
                    ++count;
                }
            }
            return count;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to count unseen messages in mailbox " + mailbox, (Throwable)e);
        }
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        JCRMailboxMessage membership = (JCRMailboxMessage)message;
        if (membership.isPersistent()) {
            try {
                this.getSession().getNodeByIdentifier(membership.getId()).remove();
            }
            catch (RepositoryException e) {
                throw new MailboxException("Unable to delete message " + message + " in mailbox " + mailbox, (Throwable)e);
            }
        }
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        try {
            List<MailboxMessage> results;
            MessageUid from = set.getUidFrom();
            MessageUid to = set.getUidTo();
            MessageRange.Type type = set.getType();
            switch (type) {
                default: {
                    results = this.findMessagesInMailbox(mailbox, max);
                    break;
                }
                case FROM: {
                    results = this.findMessagesInMailboxAfterUID(mailbox, from, max);
                    break;
                }
                case ONE: {
                    results = this.findMessageInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findMessagesInMailboxBetweenUIDs(mailbox, from, to, max);
                }
            }
            return results.iterator();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search MessageRange " + set + " in mailbox " + mailbox, (Throwable)e);
        }
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            ArrayList<MessageUid> list = new ArrayList<MessageUid>();
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:recent" + "='true'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()).getUid());
            }
            return list;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search recent messages in mailbox " + mailbox, (Throwable)e);
        }
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        try {
            String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:seen" + "='false'] order by @" + "jamesMailbox:uid";
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
            query.setLimit(1L);
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            if (iterator.hasNext()) {
                return new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()).getUid();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to find first unseen message in mailbox " + mailbox, (Throwable)e);
        }
    }

    public Map<MessageUid, MessageMetaData> expungeMarkedForDeletionInMailbox(Mailbox mailbox, MessageRange set) throws MailboxException {
        try {
            List<MailboxMessage> results;
            MessageUid from = set.getUidFrom();
            MessageUid to = set.getUidTo();
            MessageRange.Type type = set.getType();
            switch (type) {
                default: {
                    results = this.findDeletedMessagesInMailbox(mailbox);
                    break;
                }
                case FROM: {
                    results = this.findDeletedMessagesInMailboxAfterUID(mailbox, from);
                    break;
                }
                case ONE: {
                    results = this.findDeletedMessageInMailboxWithUID(mailbox, from);
                    break;
                }
                case RANGE: {
                    results = this.findDeletedMessagesInMailboxBetweenUIDs(mailbox, from, to);
                }
            }
            HashMap<MessageUid, MessageMetaData> uids = new HashMap<MessageUid, MessageMetaData>();
            for (MailboxMessage m : results) {
                MessageUid uid = m.getUid();
                uids.put(uid, (MessageMetaData)new SimpleMessageMetaData(m));
                this.delete(mailbox, m);
            }
            return uids;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to search MessageRange " + set + " in mailbox " + mailbox, (Throwable)e);
        }
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        throw new UnsupportedOperationException("Not implemented - see https://issues.apache.org/jira/browse/IMAP-370");
    }

    protected MessageMetaData copy(Mailbox mailbox, MessageUid uid, long modSeq, MailboxMessage original) throws MailboxException {
        try {
            String newMessagePath = this.getSession().getNodeByIdentifier(mailbox.getMailboxId().serialize()).getPath() + "/" + String.valueOf(uid.asLong());
            this.getSession().getWorkspace().copy(((JCRMailboxMessage)original).getNode().getPath(), this.getSession().getNodeByIdentifier(mailbox.getMailboxId().serialize()).getPath() + "/" + String.valueOf(uid.asLong()));
            Node node = this.getSession().getNode(newMessagePath);
            node.setProperty("jamesMailbox:mailboxUUID", mailbox.getMailboxId().serialize());
            node.setProperty("jamesMailbox:uid", uid.asLong());
            node.setProperty("jamesMailbox:modSeq", modSeq);
            node.setProperty("jamesMailbox:recent", true);
            return new SimpleMessageMetaData((MailboxMessage)new JCRMailboxMessage(node, this.mailboxSession.getLog()));
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to copy message " + original + " in mailbox " + mailbox, (Throwable)e);
        }
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        JCRMailboxMessage membership = (JCRMailboxMessage)message;
        try {
            Node messageNode = null;
            if (membership.isPersistent()) {
                messageNode = this.getSession().getNodeByIdentifier(membership.getId());
            }
            if (messageNode == null) {
                Node mailboxNode;
                Date date = message.getInternalDate();
                if (date == null) {
                    date = new Date();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                String year = this.convertIntToString(cal.get(1));
                String month = this.convertIntToString(cal.get(2) + 1);
                String day = this.convertIntToString(cal.get(5));
                String hour = this.convertIntToString(cal.get(11));
                String min = this.convertIntToString(cal.get(12));
                Node node = mailboxNode = this.getSession().getNodeByIdentifier(mailbox.getMailboxId().serialize());
                if (this.scaleType > 0 && this.scaleType >= 1) {
                    node = JcrUtils.getOrAddFolder((Node)node, (String)year);
                    if (this.scaleType >= 2) {
                        node = JcrUtils.getOrAddFolder((Node)node, (String)month);
                        if (this.scaleType >= 3) {
                            node = JcrUtils.getOrAddFolder((Node)node, (String)day);
                            if (this.scaleType >= 4) {
                                node = JcrUtils.getOrAddFolder((Node)node, (String)hour);
                                if (this.scaleType >= 5) {
                                    node = JcrUtils.getOrAddFolder((Node)node, (String)min);
                                }
                            }
                        }
                    }
                }
                MessageUid uid = membership.getUid();
                messageNode = mailboxNode.addNode(String.valueOf(uid.asLong()), "nt:file");
                messageNode.addMixin("jamesMailbox:message");
                try {
                    membership.merge(messageNode);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to merge message in to tree", (Throwable)e);
                }
            } else {
                membership.merge(messageNode);
            }
            return new SimpleMessageMetaData((MailboxMessage)membership);
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to save message " + message + " in mailbox " + mailbox, (Throwable)e);
        }
        catch (IOException e) {
            throw new MailboxException("Unable to save message " + message + " in mailbox " + mailbox, (Throwable)e);
        }
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        int maxBatchSize = -1;
        try {
            return new ApplicableFlagCalculator(this.findMessagesInMailbox(mailbox, maxBatchSize)).computeApplicableFlags();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to get message from in mailbox " + mailbox, (Throwable)e);
        }
    }

    private String getMailboxPath(Mailbox mailbox) throws ItemNotFoundException, RepositoryException {
        return ISO9075.encodePath((String)this.getSession().getNodeByIdentifier(mailbox.getMailboxId().serialize()).getPath());
    }

    private List<MailboxMessage> findMessagesInMailboxAfterUID(Mailbox mailbox, MessageUid from, int batchSize) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + "] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findMessageInMailboxWithUID(Mailbox mailbox, MessageUid from) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + "=" + from + "]";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findMessagesInMailboxBetweenUIDs(Mailbox mailbox, MessageUid from, MessageUid to, int batchSize) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + " and @" + "jamesMailbox:uid" + "<=" + to + "] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findMessagesInMailbox(Mailbox mailbox, int batchSize) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message) order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
        if (batchSize > 0) {
            query.setLimit((long)batchSize);
        }
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxAfterUID(Mailbox mailbox, MessageUid from) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + " and @" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findDeletedMessageInMailboxWithUID(Mailbox mailbox, MessageUid from) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + "=" + from + " and @" + "jamesMailbox:deleted" + "='true']";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        Query query = manager.createQuery(queryString, XPATH_LANGUAGE);
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            JCRMailboxMessage member = new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog());
            list.add(member);
        }
        return list;
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxBetweenUIDs(Mailbox mailbox, MessageUid from, MessageUid to) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:uid" + ">=" + from + " and @" + "jamesMailbox:uid" + "<=" + to + " and @" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            list.add(new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog()));
        }
        return list;
    }

    private List<MailboxMessage> findDeletedMessagesInMailbox(Mailbox mailbox) throws RepositoryException {
        ArrayList<MailboxMessage> list = new ArrayList<MailboxMessage>();
        String queryString = "/jcr:root" + this.getMailboxPath(mailbox) + "//element(*,jamesMailbox:message)[@" + "jamesMailbox:deleted" + "='true'] order by @" + "jamesMailbox:uid";
        QueryManager manager = this.getSession().getWorkspace().getQueryManager();
        QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
        NodeIterator iterator = result.getNodes();
        while (iterator.hasNext()) {
            JCRMailboxMessage member = new JCRMailboxMessage(iterator.nextNode(), this.mailboxSession.getLog());
            list.add(member);
        }
        return list;
    }

    private String convertIntToString(int value) {
        if (value <= 9) {
            return "0" + String.valueOf(value);
        }
        return String.valueOf(value);
    }
}

