/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.jcr.AbstractJCRScalingMapper;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.model.JCRMailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class JCRMailboxMapper
extends AbstractJCRScalingMapper
implements MailboxMapper {
    private static final String XPATH_LANGUAGE = "xpath";

    public JCRMailboxMapper(MailboxSessionJCRRepository repos, MailboxSession session, int scaling) {
        super(repos, session, scaling);
    }

    public void delete(Mailbox mailbox) throws MailboxException {
        try {
            Node node = this.getSession().getNodeByIdentifier(((JCRMailbox)mailbox).getMailboxId().serialize());
            node.remove();
        }
        catch (PathNotFoundException node) {
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to delete mailbox " + mailbox, (Throwable)e);
        }
    }

    public Mailbox findMailboxByPath(MailboxPath path) throws MailboxException, MailboxNotFoundException {
        try {
            String queryString;
            String name = Text.escapeIllegalXpathSearchChars((String)path.getName());
            String user = path.getUser();
            if (user == null) {
                user = "";
            }
            user = Text.escapeIllegalXpathSearchChars((String)user);
            String namespace = Text.escapeIllegalXpathSearchChars((String)path.getNamespace());
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            QueryResult result = manager.createQuery(queryString = "/jcr:root/mailboxes/" + ISO9075.encodePath((String)path.getNamespace()) + "//element(*,jamesMailbox:mailbox)[@" + "jamesMailbox:mailboxName" + "='" + name + "' and @" + "jamesMailbox:mailboxNamespace" + "='" + namespace + "' and @" + "jamesMailbox:mailboxUser" + "='" + user + "']", XPATH_LANGUAGE).execute();
            NodeIterator it = result.getNodes();
            if (it.hasNext()) {
                return new JCRMailbox(it.nextNode(), this.getLogger());
            }
            throw new MailboxNotFoundException(path);
        }
        catch (PathNotFoundException e) {
            throw new MailboxNotFoundException(path);
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to find mailbox " + path, (Throwable)e);
        }
    }

    public Mailbox findMailboxById(MailboxId id) throws MailboxException, MailboxNotFoundException {
        try {
            Node node = this.getSession().getNodeByIdentifier(id.serialize());
            return new JCRMailbox(node, this.getLogger());
        }
        catch (PathNotFoundException e) {
            throw new MailboxNotFoundException(id.serialize());
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to find mailbox " + id.serialize(), (Throwable)e);
        }
    }

    public List<Mailbox> findMailboxWithPathLike(MailboxPath path) throws MailboxException {
        ArrayList<Mailbox> mailboxList = new ArrayList<Mailbox>();
        try {
            String name = Text.escapeIllegalXpathSearchChars((String)path.getName());
            String user = path.getUser();
            if (user == null) {
                user = "";
            }
            user = Text.escapeIllegalXpathSearchChars((String)user);
            String namespace = Text.escapeIllegalXpathSearchChars((String)path.getNamespace());
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            String queryString = "/jcr:root/mailboxes/" + ISO9075.encodePath((String)path.getNamespace()) + "//element(*,jamesMailbox:mailbox)[jcr:like(@" + "jamesMailbox:mailboxName" + ",'%" + name + "%') and @" + "jamesMailbox:mailboxNamespace" + "='" + namespace + "' and @" + "jamesMailbox:mailboxUser" + "='" + user + "']";
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                mailboxList.add(new JCRMailbox(it.nextNode(), this.getLogger()));
            }
        }
        catch (PathNotFoundException name) {
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to find mailbox " + path, (Throwable)e);
        }
        return mailboxList;
    }

    public MailboxId save(Mailbox mailbox) throws MailboxException {
        try {
            JCRMailbox jcrMailbox = (JCRMailbox)mailbox;
            Node node = null;
            if (jcrMailbox.isPersistent()) {
                node = this.getSession().getNodeByIdentifier(jcrMailbox.getMailboxId().serialize());
            }
            if (node == null) {
                Node mailboxNode;
                Node rootNode = this.getSession().getRootNode();
                if (!rootNode.hasNode("mailboxes")) {
                    mailboxNode = rootNode.addNode("mailboxes");
                    mailboxNode.addMixin("mix:lockable");
                    this.getSession().save();
                } else {
                    mailboxNode = rootNode.getNode("mailboxes");
                }
                node = JcrUtils.getOrAddNode((Node)mailboxNode, (String)Text.escapeIllegalJcrChars((String)jcrMailbox.getNamespace()), (String)"nt:unstructured");
                if (jcrMailbox.getUser() != null) {
                    node = this.createUserPathStructure(node, Text.escapeIllegalJcrChars((String)jcrMailbox.getUser()));
                }
                node = JcrUtils.getOrAddNode((Node)node, (String)Text.escapeIllegalJcrChars((String)jcrMailbox.getName()), (String)"nt:unstructured");
                node.addMixin("jamesMailbox:mailbox");
                jcrMailbox.merge(node);
            } else {
                jcrMailbox.merge(node);
            }
            return jcrMailbox.getMailboxId();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to save mailbox " + mailbox, (Throwable)e);
        }
    }

    public boolean hasChildren(Mailbox mailbox, char delimiter) throws MailboxException, MailboxNotFoundException {
        try {
            String name = Text.escapeIllegalXpathSearchChars((String)mailbox.getName());
            String user = mailbox.getUser();
            if (user == null) {
                user = "";
            }
            user = Text.escapeIllegalXpathSearchChars((String)user);
            String namespace = Text.escapeIllegalXpathSearchChars((String)mailbox.getNamespace());
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            String queryString = "/jcr:root/mailboxes/" + ISO9075.encodePath((String)mailbox.getNamespace()) + "//element(*,jamesMailbox:mailbox)[jcr:like(@" + "jamesMailbox:mailboxName" + ",'" + name + delimiter + "%') and @" + "jamesMailbox:mailboxNamespace" + "='" + namespace + "' and @" + "jamesMailbox:mailboxUser" + "='" + user + "']";
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator it = result.getNodes();
            return it.hasNext();
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to retrieve children for mailbox " + mailbox, (Throwable)e);
        }
    }

    public List<Mailbox> list() throws MailboxException {
        try {
            ArrayList<Mailbox> mList = new ArrayList<Mailbox>();
            QueryManager manager = this.getSession().getWorkspace().getQueryManager();
            String queryString = "/jcr:root/mailboxes//element(*,jamesMailbox:mailbox)";
            QueryResult result = manager.createQuery(queryString, XPATH_LANGUAGE).execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                mList.add(new JCRMailbox(it.nextNode(), this.getLogger()));
            }
            return mList;
        }
        catch (RepositoryException e) {
            throw new MailboxException("Unable to retrieve the list of mailboxes", (Throwable)e);
        }
    }

    public void updateACL(Mailbox mailbox, MailboxACL.MailboxACLCommand mailboxACLCommand) throws MailboxException {
        mailbox.setACL(mailbox.getACL().apply(mailboxACLCommand));
    }
}

