/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.jcr.mail.JCRMailboxMapper;
import org.apache.james.mailbox.jcr.mail.JCRMessageMapper;
import org.apache.james.mailbox.jcr.user.JCRSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.NoopAttachmentMapper;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class JCRMailboxSessionMapperFactory
extends MailboxSessionMapperFactory {
    private final MailboxSessionJCRRepository repository;
    private static final int DEFAULT_SCALING = 2;
    private final int scaling;
    private final int messageScaling;
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;

    public JCRMailboxSessionMapperFactory(MailboxSessionJCRRepository repository, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        this(repository, uidProvider, modSeqProvider, 2, 3);
    }

    public JCRMailboxSessionMapperFactory(MailboxSessionJCRRepository repository, UidProvider uidProvider, ModSeqProvider modSeqProvider, int scaling, int messageScaling) {
        this.repository = repository;
        this.scaling = scaling;
        this.messageScaling = messageScaling;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) throws MailboxException {
        return new JCRMailboxMapper(this.repository, session, this.scaling);
    }

    public MessageMapper createMessageMapper(MailboxSession session) throws MailboxException {
        return new JCRMessageMapper(this.repository, session, this.uidProvider, this.modSeqProvider, this.messageScaling);
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException();
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        return new JCRSubscriptionMapper(this.repository, session, 2);
    }

    public AttachmentMapper createAttachmentMapper(MailboxSession session) throws MailboxException {
        return new NoopAttachmentMapper();
    }

    public MailboxSessionJCRRepository getRepository() {
        return this.repository;
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException();
    }

    public UidProvider getUidProvider() {
        return this.uidProvider;
    }

    public ModSeqProvider getModSeqProvider() {
        return this.modSeqProvider;
    }
}

