/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import java.util.EnumSet;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.JCRMailboxSessionMapperFactory;
import org.apache.james.mailbox.jcr.JCRMessageManager;
import org.apache.james.mailbox.jcr.mail.model.JCRMailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRMailboxManager
extends StoreMailboxManager
implements JCRImapConstants {
    private final Logger logger = LoggerFactory.getLogger(JCRMailboxManager.class);

    public JCRMailboxManager(JCRMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        this(mapperFactory, authenticator, authorizator, (MailboxPathLocker)new JVMMailboxPathLocker(), aclResolver, groupMembershipResolver, messageParser, messageIdFactory);
    }

    public JCRMailboxManager(JCRMailboxSessionMapperFactory mapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MessageParser messageParser, MessageId.Factory messageIdFactory) {
        super((MailboxSessionMapperFactory)mapperFactory, authenticator, authorizator, locker, aclResolver, groupMembershipResolver, messageParser, messageIdFactory);
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return EnumSet.of(MailboxManager.MailboxCapabilities.Namespace);
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxEntity, MailboxSession session) throws MailboxException {
        return new JCRMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), (JCRMailbox)mailboxEntity, this.getAclResolver(), this.getGroupMembershipResolver(), this.logger, this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes());
    }

    protected Mailbox doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        return new JCRMailbox(path, this.randomUidValidity(), this.logger);
    }
}

