/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StartTlsResponse;
import org.apache.james.protocols.pop3.core.CapaCapability;

public class StlsCmdHandler
implements CommandHandler<POP3Session>,
CapaCapability {
    private static final Collection<String> COMMANDS = Collections.unmodifiableCollection(Arrays.asList("STLS"));
    private static final Set<String> CAPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("STLS")));
    private static final Response BEGIN_TLS = new POP3StartTlsResponse("+OK", "Begin TLS negotiation").immutable();

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        if (session.isStartTLSSupported() && session.getHandlerState() == 0 && !session.isTLSStarted()) {
            return BEGIN_TLS;
        }
        return POP3Response.ERR;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.isStartTLSSupported() && session.getHandlerState() == 0) {
            return CAPS;
        }
        return Collections.EMPTY_SET;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

