/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.Mailbox;

public class QuitCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = Collections.unmodifiableCollection(Arrays.asList("QUIT"));
    private static final Response SIGN_OFF;
    private static final Response SIGN_OFF_NOT_CLEAN;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Response onCommand(POP3Session session, Request request) {
        Response response = null;
        if (session.getHandlerState() == 0 || session.getHandlerState() == 1) {
            return SIGN_OFF;
        }
        List toBeRemoved = (List)session.getAttachment("DELETED_UID_LIST", ProtocolSession.State.Transaction);
        Mailbox mailbox = session.getUserMailbox();
        try {
            String[] uids = toBeRemoved.toArray(new String[toBeRemoved.size()]);
            mailbox.remove(uids);
            response = SIGN_OFF;
        }
        catch (Exception ex) {
            response = SIGN_OFF_NOT_CLEAN;
            session.getLogger().error("Some deleted messages were not removed", (Throwable)ex);
        }
        try {
            mailbox.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    static {
        POP3Response response = new POP3Response("+OK", "Apache James POP3 Server signing off.");
        response.setEndSession(true);
        SIGN_OFF = response.immutable();
        response = new POP3Response("-ERR", "Some deleted messages were not removed");
        response.setEndSession(true);
        SIGN_OFF_NOT_CLEAN = response.immutable();
    }
}

