/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.RsetCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;

public abstract class AbstractPassCmdHandler
extends RsetCmdHandler {
    private static final Collection<String> COMMANDS = Collections.unmodifiableCollection(Arrays.asList("PASS"));
    private static final Response UNEXPECTED_ERROR = new POP3Response("-ERR", "Unexpected error accessing mailbox").immutable();
    protected static final Response AUTH_FAILED = new POP3Response("-ERR", "Authentication failed.").immutable();

    @Override
    public Response onCommand(POP3Session session, Request request) {
        String parameters = request.getArgument();
        if (session.getHandlerState() == 1 && parameters != null) {
            return this.doAuth(session, session.getUser(), parameters);
        }
        session.setHandlerState(0);
        return AUTH_FAILED;
    }

    protected final Response doAuth(POP3Session session, String user, String pass) {
        try {
            Mailbox mailbox = this.auth(session, user, pass);
            if (mailbox != null) {
                session.setUserMailbox(mailbox);
                this.stat(session);
                session.setHandlerState(2);
                StringBuilder responseBuffer = new StringBuilder(64).append("Welcome ").append(session.getUser());
                return new POP3Response("+OK", responseBuffer.toString());
            }
            session.setHandlerState(0);
            return AUTH_FAILED;
        }
        catch (Exception e) {
            session.getLogger().error("Unexpected error accessing mailbox for " + session.getUser(), (Throwable)e);
            session.setHandlerState(0);
            return UNEXPECTED_ERROR;
        }
    }

    @Override
    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    protected abstract Mailbox auth(POP3Session var1, String var2, String var3) throws Exception;
}

