/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;

public abstract class AbstractApopCmdHandler
extends AbstractPassCmdHandler {
    private static final Collection<String> COMMANDS = Collections.unmodifiableCollection(Arrays.asList("APOP"));

    @Override
    public Response onCommand(POP3Session session, Request request) {
        if (session.getAttachment("APOP_TIMESTAMP", ProtocolSession.State.Connection) == null) {
            return POP3Response.ERR;
        }
        String parameters = request.getArgument();
        String[] parts = null;
        boolean syntaxError = false;
        if (parameters != null) {
            parts = parameters.split(" ");
            if (parts.length != 2) {
                syntaxError = true;
            }
        } else {
            syntaxError = true;
        }
        if (!syntaxError && session.getHandlerState() == 0) {
            Response response = this.doAuth(session, parts[0], parts[1]);
            if ("+OK".equals(response.getRetCode())) {
                session.setUser(parts[0]);
            }
            return response;
        }
        session.setHandlerState(0);
        return AUTH_FAILED;
    }

    @Override
    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected final Mailbox auth(POP3Session session, String username, String password) throws Exception {
        return this.auth(session, (String)session.getAttachment("APOP_TIMESTAMP", ProtocolSession.State.Connection), username, password);
    }

    protected abstract Mailbox auth(POP3Session var1, String var2, String var3, String var4) throws Exception;
}

