/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.utils;

public class ValueWithUnit {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UNLIMITED = "UNLIMITED";
    private static final long base = 1024L;
    Unit unit;
    Long value;

    private ValueWithUnit(Unit unit, Long value) {
        this.unit = unit;
        this.value = value;
    }

    public static ValueWithUnit parse(String providedLongWithUnitString) throws Exception {
        if (providedLongWithUnitString.equalsIgnoreCase(UNKNOWN)) {
            return new ValueWithUnit(Unit.NoUnit, Long.MIN_VALUE);
        }
        if (providedLongWithUnitString.equalsIgnoreCase(UNLIMITED)) {
            return new ValueWithUnit(Unit.NoUnit, -1L);
        }
        char lastChar = providedLongWithUnitString.charAt(providedLongWithUnitString.length() - 1);
        Unit unit = ValueWithUnit.getUnit(lastChar);
        String argWithoutUnit = ValueWithUnit.removeLastCharIfNeeded(providedLongWithUnitString, unit);
        return new ValueWithUnit(unit, Long.parseLong(argWithoutUnit));
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Long getValue() {
        return this.value;
    }

    public long getConvertedValue() {
        switch (this.unit) {
            case G: {
                this.value = this.value * 1024L;
            }
            case M: {
                this.value = this.value * 1024L;
            }
            case K: {
                this.value = this.value * 1024L;
            }
        }
        return this.value;
    }

    private static String removeLastCharIfNeeded(String providedLongWithUnitString, Unit unit) {
        if (unit != Unit.NoUnit) {
            return providedLongWithUnitString.substring(0, providedLongWithUnitString.length() - 1);
        }
        return providedLongWithUnitString;
    }

    private static Unit getUnit(char lastChar) throws Exception {
        switch (lastChar) {
            case 'K': 
            case 'k': {
                return Unit.K;
            }
            case 'M': 
            case 'm': {
                return Unit.M;
            }
            case 'G': 
            case 'g': {
                return Unit.G;
            }
            case 'B': 
            case 'b': {
                return Unit.B;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Unit.NoUnit;
            }
        }
        throw new Exception("No unit corresponding to char : " + lastChar);
    }

    private static enum Unit {
        NoUnit,
        B,
        K,
        M,
        G;

    }
}

