/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.store.mail.model.SerializableQuota;
import org.apache.james.mailbox.store.probe.QuotaProbe;

public class JmxQuotaProbe
implements QuotaProbe,
JmxProbe {
    private static final String QUOTAMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=quotamanagerbean";
    private QuotaManagementMBean quotaManagement;

    @Override
    public JmxQuotaProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.quotaManagement = jmxc.retrieveBean(QuotaManagementMBean.class, QUOTAMANAGER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        return this.quotaManagement.getQuotaRoot(namespace, user, name);
    }

    public SerializableQuota getMessageCountQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMessageCountQuota(quotaRoot);
    }

    public SerializableQuota getStorageQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getStorageQuota(quotaRoot);
    }

    public long getMaxMessageCount(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxMessageCount(quotaRoot);
    }

    public long getMaxStorage(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxStorage(quotaRoot);
    }

    public long getDefaultMaxMessageCount() throws MailboxException {
        return this.quotaManagement.getDefaultMaxMessageCount();
    }

    public long getDefaultMaxStorage() throws MailboxException {
        return this.quotaManagement.getDefaultMaxStorage();
    }

    public void setMaxMessageCount(String quotaRoot, long maxMessageCount) throws MailboxException {
        this.quotaManagement.setMaxMessageCount(quotaRoot, maxMessageCount);
    }

    public void setMaxStorage(String quotaRoot, long maxSize) throws MailboxException {
        this.quotaManagement.setMaxStorage(quotaRoot, maxSize);
    }

    public void setDefaultMaxMessageCount(long maxDefaultMessageCount) throws MailboxException {
        this.quotaManagement.setDefaultMaxMessageCount(maxDefaultMessageCount);
    }

    public void setDefaultMaxStorage(long maxDefaultSize) throws MailboxException {
        this.quotaManagement.setDefaultMaxStorage(maxDefaultSize);
    }
}

