/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import javax.mail.Flags;
import javax.management.MalformedObjectNameException;
import org.apache.james.adapter.mailbox.MailboxCopierManagementMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.adapter.mailbox.ReIndexerManagementMBean;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.probe.MailboxProbe;

public class JmxMailboxProbe
implements MailboxProbe,
JmxProbe {
    private static final String MAILBOXCOPIER_OBJECT_NAME = "org.apache.james:type=component,name=mailboxcopier";
    private static final String MAILBOXMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=mailboxmanagerbean";
    private static final String REINDEXER_OBJECT_NAME = "org.apache.james:type=component,name=reindexerbean";
    private MailboxCopierManagementMBean mailboxCopierManagement;
    private MailboxManagerManagementMBean mailboxManagerManagement;
    private ReIndexerManagementMBean reIndexerManagement;

    @Override
    public JmxMailboxProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.mailboxCopierManagement = jmxc.retrieveBean(MailboxCopierManagementMBean.class, MAILBOXCOPIER_OBJECT_NAME);
            this.mailboxManagerManagement = jmxc.retrieveBean(MailboxManagerManagementMBean.class, MAILBOXMANAGER_OBJECT_NAME);
            this.reIndexerManagement = jmxc.retrieveBean(ReIndexerManagementMBean.class, REINDEXER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void copyMailbox(String srcBean, String dstBean) throws Exception {
        this.mailboxCopierManagement.copy(srcBean, dstBean);
    }

    public void deleteUserMailboxesNames(String user) throws Exception {
        this.mailboxManagerManagement.deleteMailboxes(user);
    }

    public void createMailbox(String namespace, String user, String name) {
        this.mailboxManagerManagement.createMailbox(namespace, user, name);
    }

    public Collection<String> listUserMailboxes(String user) {
        return this.mailboxManagerManagement.listMailboxes(user);
    }

    public void deleteMailbox(String namespace, String user, String name) {
        this.mailboxManagerManagement.deleteMailbox(namespace, user, name);
    }

    public void reIndexMailbox(String namespace, String user, String name) throws Exception {
        this.reIndexerManagement.reIndex(namespace, user, name);
    }

    public void reIndexAll() throws Exception {
        this.reIndexerManagement.reIndex();
    }

    public Mailbox getMailbox(String namespace, String user, String name) {
        return null;
    }

    public ComposedMessageId appendMessage(String username, MailboxPath mailboxPath, InputStream message, Date internalDate, boolean isRecent, Flags flags) throws MailboxException {
        return null;
    }

    public Collection<String> listSubscriptions(String user) throws Exception {
        return null;
    }
}

