/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.domainlist.api.DomainListManagementMBean;
import org.apache.james.probe.DataProbe;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepositoryManagementMBean;

public class JmxDataProbe
implements DataProbe,
JmxProbe {
    private static final String DOMAINLIST_OBJECT_NAME = "org.apache.james:type=component,name=domainlist";
    private static final String VIRTUALUSERTABLE_OBJECT_NAME = "org.apache.james:type=component,name=recipientrewritetable";
    private static final String USERSREPOSITORY_OBJECT_NAME = "org.apache.james:type=component,name=usersrepository";
    private DomainListManagementMBean domainListProxy;
    private RecipientRewriteTableManagementMBean virtualUserTableProxy;
    private UsersRepositoryManagementMBean usersRepositoryProxy;

    @Override
    public JmxDataProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.domainListProxy = jmxc.retrieveBean(DomainListManagementMBean.class, DOMAINLIST_OBJECT_NAME);
            this.virtualUserTableProxy = jmxc.retrieveBean(RecipientRewriteTableManagementMBean.class, VIRTUALUSERTABLE_OBJECT_NAME);
            this.usersRepositoryProxy = jmxc.retrieveBean(UsersRepositoryManagementMBean.class, USERSREPOSITORY_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void addUser(String userName, String password) throws Exception {
        this.usersRepositoryProxy.addUser(userName, password);
    }

    public void removeUser(String username) throws Exception {
        this.usersRepositoryProxy.deleteUser(username);
    }

    public String[] listUsers() throws Exception {
        return this.usersRepositoryProxy.listAllUsers();
    }

    public void setPassword(String userName, String password) throws Exception {
        this.usersRepositoryProxy.setPassword(userName, password);
    }

    public boolean containsDomain(String domain) throws Exception {
        return this.domainListProxy.containsDomain(domain);
    }

    public String getDefaultDomain() throws Exception {
        return this.domainListProxy.getDefaultDomain();
    }

    public void addDomain(String domain) throws Exception {
        this.domainListProxy.addDomain(domain);
    }

    public void removeDomain(String domain) throws Exception {
        this.domainListProxy.removeDomain(domain);
    }

    public List<String> listDomains() throws Exception {
        return this.domainListProxy.getDomains();
    }

    public Map<String, Mappings> listMappings() throws Exception {
        return this.virtualUserTableProxy.getAllMappings();
    }

    public void addAddressMapping(String user, String domain, String toAddress) throws Exception {
        this.virtualUserTableProxy.addAddressMapping(user, domain, toAddress);
    }

    public void removeAddressMapping(String user, String domain, String fromAddress) throws Exception {
        this.virtualUserTableProxy.removeAddressMapping(user, domain, fromAddress);
    }

    public Mappings listUserDomainMappings(String user, String domain) throws Exception {
        return this.virtualUserTableProxy.getUserDomainMappings(user, domain);
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        this.virtualUserTableProxy.addRegexMapping(user, domain, regex);
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        this.virtualUserTableProxy.removeRegexMapping(user, domain, regex);
    }
}

