/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.mailbox;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class MaxQuotaConfigurationReader
implements Configurable {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    public MaxQuotaConfigurationReader(MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        Long defaultMaxMessage = config.configurationAt("maxQuotaManager").getLong("defaultMaxMessage", null);
        Long defaultMaxStorage = config.configurationAt("maxQuotaManager").getLong("defaultMaxStorage", null);
        Map<String, Long> maxMessage = this.parseMaxMessageConfiguration(config, "maxMessage");
        Map<String, Long> maxStorage = this.parseMaxMessageConfiguration(config, "maxStorage");
        try {
            this.configureDefaultValues(defaultMaxMessage, defaultMaxStorage);
            this.configureQuotaRootSpecificValues(maxMessage, maxStorage);
        }
        catch (MailboxException e) {
            throw new ConfigurationException("Exception caught while configuring max quota manager", (Throwable)e);
        }
    }

    private Map<String, Long> parseMaxMessageConfiguration(HierarchicalConfiguration config, String entry) {
        List maxMessageConfiguration = config.configurationAt("maxQuotaManager").configurationsAt(entry);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (HierarchicalConfiguration conf : maxMessageConfiguration) {
            result.put(conf.getString("quotaRoot"), conf.getLong("value"));
        }
        return result;
    }

    private void configureDefaultValues(Long defaultMaxMessage, Long defaultMaxStorage) throws MailboxException {
        if (defaultMaxMessage != null) {
            this.maxQuotaManager.setDefaultMaxMessage(defaultMaxMessage.longValue());
        }
        if (defaultMaxStorage != null) {
            this.maxQuotaManager.setDefaultMaxStorage(defaultMaxStorage.longValue());
        }
    }

    private void configureQuotaRootSpecificValues(Map<String, Long> maxMessage, Map<String, Long> maxStorage) throws MailboxException {
        for (Map.Entry<String, Long> entry : maxMessage.entrySet()) {
            this.maxQuotaManager.setMaxMessage(this.quotaRootResolver.createQuotaRoot(entry.getKey()), entry.getValue().longValue());
        }
        for (Map.Entry<String, Long> entry : maxStorage.entrySet()) {
            this.maxQuotaManager.setMaxStorage(this.quotaRootResolver.createQuotaRoot(entry.getKey()), entry.getValue().longValue());
        }
    }
}

