/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.context;

import org.apache.james.container.spring.resource.DefaultJamesResourceLoader;
import org.apache.james.container.spring.resource.JamesResourceLoader;
import org.apache.james.core.JamesServerResourceLoader;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public class JamesServerApplicationContext
extends ClassPathXmlApplicationContext
implements JamesResourceLoader {
    private static final JamesResourceLoader resourceLoader = new DefaultJamesResourceLoader((JamesDirectoriesProvider)new JamesServerResourceLoader("../"));

    public JamesServerApplicationContext(String[] configs) {
        super(configs);
    }

    protected JamesResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public Resource getResource(String fileURL) {
        Resource r = this.getResourceLoader().getResource(fileURL);
        if (r == null) {
            r = super.getResource(fileURL);
        }
        return r;
    }

    public String getAbsoluteDirectory() {
        return this.getResourceLoader().getAbsoluteDirectory();
    }

    public String getConfDirectory() {
        return this.getResourceLoader().getConfDirectory();
    }

    public String getVarDirectory() {
        return this.getResourceLoader().getVarDirectory();
    }

    public String getRootDirectory() {
        return this.getResourceLoader().getRootDirectory();
    }
}

