/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueRef;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.AbstractValue;

public class MapValueImpl
extends AbstractValue
implements MapValue {
    private static MapValueImpl EMPTY = new MapValueImpl(new Value[0]);
    private final Value[] array;
    private transient int cursor = 0;

    public static MapValue empty() {
        return EMPTY;
    }

    public MapValueImpl(Value[] valueArray) {
        this.array = valueArray;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.MAP;
    }

    @Override
    public Value[] toKeyValueSeq() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public int size() {
        return this.array.length / 2;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    @Override
    public ValueRef nextKeyOrValue() {
        return this.array[this.cursor++];
    }

    @Override
    public void skipKeyOrValue() {
        ++this.cursor;
    }

    @Override
    public void skipAll() {
        while (this.hasNext()) {
            this.skipKeyOrValue();
        }
    }

    @Override
    public Map<Value, Value> toMap() {
        return new MapImpl();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packMapHeader(this.array.length / 2);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i].writeTo(messagePacker);
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitMap(this);
    }

    @Override
    public MapValue toValue() {
        return ValueFactory.newMap(this.array);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isMap()) {
            return false;
        }
        Map<Value, Value> map = value.asMapValue().toMap();
        if (map.size() != this.array.length / 2) {
            return false;
        }
        try {
            for (int i = 0; i < this.array.length; i += 2) {
                Value value2 = this.array[i + 1];
                Value value3 = this.array[i];
                if (value2.equals(map.get(value3))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.array.length; i += 2) {
            n += this.array[i].hashCode() ^ this.array[i + 1].hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private StringBuilder toString(StringBuilder stringBuilder) {
        if (this.array.length == 0) {
            return stringBuilder.append("{}");
        }
        stringBuilder.append("{");
        stringBuilder.append(this.array[0]);
        stringBuilder.append(":");
        stringBuilder.append(this.array[1]);
        for (int i = 2; i < this.array.length; i += 2) {
            stringBuilder.append(",");
            stringBuilder.append(this.array[i].toString());
            stringBuilder.append(":");
            stringBuilder.append(this.array[i + 1].toString());
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    private class MapImpl
    extends AbstractMap<Value, Value> {
        private MapImpl() {
        }

        @Override
        public Set<Map.Entry<Value, Value>> entrySet() {
            return new EntrySet();
        }

        @Override
        public Set<Value> keySet() {
            return new KeySet();
        }

        @Override
        public Collection<Value> values() {
            return new ValueCollection();
        }

        @Override
        public Value get(Object object) {
            for (int i = MapValueImpl.this.array.length - 2; i >= 0; i -= 2) {
                if (!MapValueImpl.this.array[i].equals(object)) continue;
                return MapValueImpl.this.array[i + 1];
            }
            return null;
        }

        private class ValueIterator
        implements Iterator<Value> {
            private int pos;

            ValueIterator(int n) {
                this.pos = n;
            }

            @Override
            public boolean hasNext() {
                return this.pos < MapValueImpl.this.array.length;
            }

            @Override
            public Value next() {
                if (this.pos >= MapValueImpl.this.array.length) {
                    throw new NoSuchElementException();
                }
                Value value = MapValueImpl.this.array[this.pos];
                this.pos += 2;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class ValueCollection
        extends AbstractCollection<Value> {
            private ValueCollection() {
            }

            @Override
            public int size() {
                return MapValueImpl.this.array.length / 2;
            }

            @Override
            public Iterator<Value> iterator() {
                return new ValueIterator(1);
            }
        }

        private class KeySet
        extends AbstractSet<Value> {
            private KeySet() {
            }

            @Override
            public int size() {
                return MapValueImpl.this.array.length / 2;
            }

            @Override
            public Iterator<Value> iterator() {
                return new ValueIterator(0);
            }
        }

        private class EntrySetIterator
        implements Iterator<Map.Entry<Value, Value>> {
            private int pos = 0;

            private EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.pos < MapValueImpl.this.array.length;
            }

            @Override
            public Map.Entry<Value, Value> next() {
                if (this.pos >= MapValueImpl.this.array.length) {
                    throw new NoSuchElementException();
                }
                Value value = MapValueImpl.this.array[this.pos];
                Value value2 = MapValueImpl.this.array[this.pos + 1];
                AbstractMap.SimpleImmutableEntry<Value, Value> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Value, Value>(value, value2);
                this.pos += 2;
                return simpleImmutableEntry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<Value, Value>> {
            private EntrySet() {
            }

            @Override
            public int size() {
                return MapValueImpl.this.array.length / 2;
            }

            @Override
            public Iterator<Map.Entry<Value, Value>> iterator() {
                return new EntrySetIterator();
            }
        }
    }
}

