/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.msgpack.core.MessageFloatOverflowException;
import org.msgpack.core.MessageOverflowException;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.FloatValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.AbstractValue;

public class FloatValueImpl
extends AbstractValue
implements FloatValue {
    private final float value;

    public FloatValueImpl(float f) {
        this.value = f;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public boolean isValidByte() {
        return (float)((byte)this.value) == this.value;
    }

    @Override
    public boolean isValidShort() {
        return (float)((short)this.value) == this.value;
    }

    @Override
    public boolean isValidInt() {
        int n = (int)this.value;
        return (float)n == this.value && n != Integer.MAX_VALUE;
    }

    @Override
    public boolean isValidLong() {
        long l = (long)this.value;
        return (float)l == this.value && l != Long.MAX_VALUE;
    }

    @Override
    public boolean isWhole() {
        long l = (long)this.value;
        return (float)l == this.value || l == Long.MAX_VALUE || this.value < Float.POSITIVE_INFINITY || l == Long.MIN_VALUE && this.value > Float.NEGATIVE_INFINITY;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigDecimal(this.value).toBigInteger();
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public byte asByte() throws MessageOverflowException {
        if (!this.isValidByte()) {
            throw new MessageFloatOverflowException(this.value);
        }
        return (byte)this.value;
    }

    @Override
    public short asShort() throws MessageOverflowException {
        if (!this.isValidShort()) {
            throw new MessageFloatOverflowException(this.value);
        }
        return (short)this.value;
    }

    @Override
    public int asInt() throws MessageOverflowException {
        if (!this.isValidInt()) {
            throw new MessageFloatOverflowException(this.value);
        }
        return (int)this.value;
    }

    @Override
    public long asLong() throws MessageOverflowException {
        if (!this.isValidLong()) {
            throw new MessageFloatOverflowException(this.value);
        }
        return (long)this.value;
    }

    @Override
    public BigInteger asBigInteger() throws MessageOverflowException {
        if (!this.isWhole()) {
            throw new MessageFloatOverflowException(this.value);
        }
        return BigDecimal.valueOf(this.value).toBigInteger();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isFloat()) {
            return false;
        }
        return (double)this.value == value.asFloat().toDouble();
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packFloat(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitFloat(this);
    }

    @Override
    public FloatValue toValue() {
        return this;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

