/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.core.MessageIntegerOverflowException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.Preconditions;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.impl.AbstractValue;

public class BigIntegerValueImpl
extends AbstractValue
implements IntegerValue {
    private final BigInteger value;
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    private static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public BigIntegerValueImpl(BigInteger bigInteger) {
        this.value = Preconditions.checkNotNull(bigInteger, "BigInteger value is null");
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public byte toByte() {
        return this.value.byteValue();
    }

    @Override
    public short toShort() {
        return this.value.shortValue();
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }

    @Override
    public long toLong() {
        return this.value.longValue();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value.floatValue();
    }

    @Override
    public double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public byte asByte() throws MessageIntegerOverflowException {
        if (!this.isValidByte()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.byteValue();
    }

    @Override
    public short asShort() throws MessageIntegerOverflowException {
        if (!this.isValidShort()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.shortValue();
    }

    @Override
    public int asInt() throws MessageIntegerOverflowException {
        if (!this.isValidInt()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.intValue();
    }

    @Override
    public long asLong() throws MessageIntegerOverflowException {
        if (!this.isValidLong()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.longValue();
    }

    @Override
    public BigInteger asBigInteger() throws MessageIntegerOverflowException {
        return this.value;
    }

    @Override
    public boolean isValidByte() {
        return 0 <= this.value.compareTo(BYTE_MIN) && this.value.compareTo(BYTE_MAX) <= 0;
    }

    @Override
    public boolean isValidShort() {
        return 0 <= this.value.compareTo(SHORT_MIN) && this.value.compareTo(SHORT_MAX) <= 0;
    }

    @Override
    public boolean isValidInt() {
        return 0 <= this.value.compareTo(INT_MIN) && this.value.compareTo(INT_MAX) <= 0;
    }

    @Override
    public boolean isValidLong() {
        return 0 <= this.value.compareTo(LONG_MIN) && this.value.compareTo(LONG_MAX) <= 0;
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBigInteger(this.value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        valueVisitor.visitInteger(this);
    }

    @Override
    public IntegerValue toValue() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isInteger()) {
            return false;
        }
        IntegerValue integerValue = value.asInteger();
        return this.value.equals(integerValue.toBigInteger());
    }

    public int hashCode() {
        if (INT_MIN.compareTo(this.value) <= 0 && this.value.compareTo(INT_MAX) <= 0) {
            return (int)this.value.longValue();
        }
        if (LONG_MIN.compareTo(this.value) <= 0 && this.value.compareTo(LONG_MAX) <= 0) {
            long l = this.value.longValue();
            return (int)(l ^ l >>> 32);
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

