/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.holder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageStringCodingException;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.value.BinaryValue;
import org.msgpack.value.RawValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;
import org.msgpack.value.ValueVisitor;
import org.msgpack.value.holder.RawHolderImpl;

public class RawHolder
extends RawHolderImpl {
    private StringValueWrap stringWrap = new StringValueWrap();
    private BinaryValueWrap binaryWrap = new BinaryValueWrap();

    @Override
    public void setString(MessageBuffer messageBuffer) {
        this.tpe = RawHolderImpl.Type.STRING;
        this.buf = messageBuffer;
        this.stringWrap.setString(messageBuffer);
    }

    @Override
    public void setBinary(MessageBuffer messageBuffer) {
        this.tpe = RawHolderImpl.Type.BINARY;
        this.buf = messageBuffer;
        this.binaryWrap.setBinary(messageBuffer);
    }

    @Override
    public MessageBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public byte[] toByteArray() {
        switch (this.tpe) {
            case STRING: 
            case BINARY: {
                return this.buf.toByteArray();
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        switch (this.tpe) {
            case STRING: {
                return this.buf.toByteBuffer();
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public MessageBuffer toMessageBuffer() {
        return this.buf;
    }

    @Override
    public String toString() throws MessageStringCodingException {
        switch (this.tpe) {
            case STRING: {
                return new String(this.buf.toByteArray(), MessagePack.UTF8);
            }
            case BINARY: {
                return this.buf.toHexString(0, this.buf.size());
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public ValueType getValueType() {
        switch (this.tpe) {
            case STRING: {
                return ValueType.STRING;
            }
            case BINARY: {
                return ValueType.BINARY;
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        switch (this.tpe) {
            case STRING: {
                messagePacker.packRawStringHeader(this.buf.size()).writePayload(this.buf.toByteBuffer());
                break;
            }
            case BINARY: {
                messagePacker.packBinaryHeader(this.buf.size()).writePayload(this.buf.toByteBuffer());
                break;
            }
            default: {
                throw MessagePackException.UNREACHABLE;
            }
        }
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        switch (this.tpe) {
            case STRING: {
                valueVisitor.visitString(this.asString());
                break;
            }
            case BINARY: {
                valueVisitor.visitBinary(this.asBinary());
                break;
            }
            default: {
                throw MessagePackException.UNREACHABLE;
            }
        }
    }

    @Override
    public RawValue toValue() {
        switch (this.tpe) {
            case STRING: {
                return ValueFactory.newRawString(this.buf.toByteArray());
            }
            case BINARY: {
                return ValueFactory.newBinary(this.buf.toByteArray());
            }
        }
        throw MessagePackException.UNREACHABLE;
    }

    @Override
    public StringValue asString() {
        return this.stringWrap;
    }

    @Override
    public BinaryValue asBinary() {
        return this.binaryWrap;
    }

    private static class BinaryValueWrap
    extends RawHolderImpl
    implements BinaryValue {
        private BinaryValueWrap() {
        }

        @Override
        public BinaryValue toValue() {
            return ValueFactory.newBinary(this.buf.toByteArray());
        }
    }

    private static class StringValueWrap
    extends RawHolderImpl
    implements StringValue {
        private StringValueWrap() {
        }

        @Override
        public StringValue toValue() {
            return ValueFactory.newRawString(this.buf.toByteArray());
        }
    }
}

