/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.maildir.MaildirId;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.maildir.mail.model.MaildirMessage;
import org.apache.james.mailbox.store.mail.model.DelegatingMailboxMessage;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;

public class MaildirMailboxMessage
extends DelegatingMailboxMessage {
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private final Mailbox mailbox;
    private MessageUid uid;
    protected boolean newMessage;
    private long modSeq;

    public MaildirMailboxMessage(Mailbox mailbox, MessageUid messageUid, MaildirMessageName messageName) throws IOException {
        super((Message)new MaildirMessage(messageName));
        this.mailbox = mailbox;
        this.setUid(messageUid);
        this.setModSeq(messageName.getFile().lastModified());
        Flags flags = messageName.getFlags();
        File file = messageName.getFile();
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to read file " + file.getAbsolutePath() + " for the message");
        }
        if (file.getParentFile().getName().equals("new")) {
            if (flags == null) {
                flags = new Flags();
            }
            flags.add(Flags.Flag.RECENT);
        }
        this.setFlags(flags);
    }

    public MaildirId getMailboxId() {
        return (MaildirId)this.mailbox.getMailboxId();
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public void setUid(MessageUid uid) {
        this.uid = uid;
    }

    public void setFlags(Flags flags) {
        if (flags != null) {
            this.answered = flags.contains(Flags.Flag.ANSWERED);
            this.deleted = flags.contains(Flags.Flag.DELETED);
            this.draft = flags.contains(Flags.Flag.DRAFT);
            this.flagged = flags.contains(Flags.Flag.FLAGGED);
            this.recent = flags.contains(Flags.Flag.RECENT);
            this.seen = flags.contains(Flags.Flag.SEEN);
        }
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public boolean isRecent() {
        return this.recent;
    }

    public boolean isSeen() {
        return this.seen;
    }

    public boolean isNew() {
        return this.newMessage;
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public void setModSeq(long modSeq) {
        this.modSeq = modSeq;
    }

    public String toString() {
        StringBuilder theString = new StringBuilder("MaildirMailboxMessage ");
        theString.append(this.getUid());
        theString.append(" {");
        Flags flags = this.createFlags();
        if (flags.contains(Flags.Flag.DRAFT)) {
            theString.append("D");
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            theString.append("F");
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            theString.append("R");
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            theString.append("S");
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            theString.append("T");
        }
        theString.append("} ");
        theString.append(this.getInternalDate());
        return theString.toString();
    }
}

