/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.util.LinkedList;

public class UidConstraint {
    private final LinkedList<Constraint> constraints = new LinkedList();

    public UidConstraint append(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public UidConstraint equals(long uid) {
        this.constraints.add(new Equals(uid));
        return this;
    }

    public UidConstraint lessOrEquals(long uid) {
        this.constraints.add(new LessOrEquals(uid));
        return this;
    }

    public UidConstraint greaterOrEquals(long uid) {
        this.constraints.add(new GreaterOrEquals(uid));
        return this;
    }

    public UidConstraint between(long lower, long upper) {
        this.constraints.add(new Between(lower, upper));
        return this;
    }

    public boolean isAllowed(long uid) {
        for (Constraint constraint : this.constraints) {
            if (constraint.isAllowed(uid)) continue;
            return false;
        }
        return true;
    }

    public static class Between
    extends Constraint {
        private final long lower;
        private final long upper;

        public Between(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean isAllowed(long uid) {
            return uid >= this.lower && uid <= this.upper;
        }
    }

    public static class GreaterOrEquals
    extends Constraint {
        private final long uid;

        public GreaterOrEquals(long uid) {
            this.uid = uid;
        }

        @Override
        public boolean isAllowed(long uid) {
            return uid >= this.uid;
        }
    }

    public static class LessOrEquals
    extends Constraint {
        private final long uid;

        public LessOrEquals(long uid) {
            this.uid = uid;
        }

        @Override
        public boolean isAllowed(long uid) {
            return uid <= this.uid;
        }
    }

    public static class Equals
    extends Constraint {
        private final long uid;

        public Equals(long uid) {
            this.uid = uid;
        }

        @Override
        public boolean isAllowed(long uid) {
            return this.uid == uid;
        }
    }

    public static abstract class Constraint {
        public abstract boolean isAllowed(long var1);
    }
}

