/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import org.apache.james.mailbox.maildir.MaildirFolder;

public class MaildirMessageName {
    public static final String FLAG_DRAFT = "D";
    public static final String FLAG_FLAGGED = "F";
    public static final String FLAG_ANSWERD = "R";
    public static final String FLAG_SEEN = "S";
    public static final String FLAG_DELETED = "T";
    public static final String PATTERN_STRING_MESSAGE_NAME = "\\d+\\.\\w+\\..+?";
    public static final String PATTERN_STRING_FLAGS = ":2,[DFRST]*";
    public static final String PATTERN_STRING_SIZE = ",S=\\d+";
    public static final Pattern PATTERN_MESSAGE = Pattern.compile("\\d+\\.\\w+\\..+?" + MaildirMessageName.optional(",S=\\d+") + MaildirMessageName.optional(":2,[DFRST]*"));
    public static final Pattern PATTERN_UNSEEN_MESSAGES = Pattern.compile("\\d+\\.\\w+\\..+?,S=\\d+" + MaildirMessageName.optional(":2,[^S]*"));
    public static final FilenameFilter FILTER_UNSEEN_MESSAGES = MaildirMessageName.createRegexFilter(PATTERN_UNSEEN_MESSAGES);
    public static final Pattern PATTERN_DELETED_MESSAGES = Pattern.compile("\\d+\\.\\w+\\..+?,S=\\d+:2,.*T");
    public static final FilenameFilter FILTER_DELETED_MESSAGES = MaildirMessageName.createRegexFilter(PATTERN_DELETED_MESSAGES);
    private static final AtomicInteger deliveries = new AtomicInteger(0);
    private static final Random random = new Random();
    private static String processName = ManagementFactory.getRuntimeMXBean().getName();
    private static String currentHostname;
    private String fullName;
    private File file;
    private final MaildirFolder parentFolder;
    private String timestamp;
    private String uniqueString;
    private String hostnameAndMeta;
    private String hostname;
    private String sizeString;
    private String flagsString;
    private boolean isSplit;
    private Date internalDate;
    private Long size;
    private Flags flags;
    private boolean messageNameStrictParse = false;

    public MaildirMessageName(MaildirFolder parentFolder, String fullName) {
        this.parentFolder = parentFolder;
        this.setFullName(fullName);
    }

    public boolean isMessageNameStrictParse() {
        return this.messageNameStrictParse;
    }

    public void setMessageNameStrictParse(boolean messageNameStrictParse) {
        this.messageNameStrictParse = messageNameStrictParse;
    }

    public boolean exists() {
        if (this.file != null && this.file.isFile()) {
            return true;
        }
        File assumedFile1 = new File(this.parentFolder.getCurFolder(), this.fullName);
        if (assumedFile1.isFile()) {
            this.file = assumedFile1;
            return true;
        }
        File assumedFile2 = new File(this.parentFolder.getNewFolder(), this.fullName);
        if (assumedFile2.isFile()) {
            this.file = assumedFile2;
            return true;
        }
        FilenameFilter filter = this.getFilenameFilter();
        File[] matchingFiles1 = this.parentFolder.getCurFolder().listFiles(filter);
        if (matchingFiles1.length == 1) {
            this.setFullName(matchingFiles1[0].getName());
            this.file = matchingFiles1[0];
            return true;
        }
        File[] matchingFiles2 = this.parentFolder.getNewFolder().listFiles(filter);
        if (matchingFiles2.length == 1) {
            this.setFullName(matchingFiles2[0].getName());
            this.file = matchingFiles2[0];
            return true;
        }
        return false;
    }

    public void setFullName(String fullName) {
        if (this.fullName == null || !this.fullName.equals(fullName)) {
            this.fullName = fullName;
            this.file = null;
            this.isSplit = false;
            this.internalDate = null;
            this.size = null;
            this.flags = null;
        }
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuilder fullBuffer = new StringBuilder();
            fullBuffer.append(this.timestamp);
            fullBuffer.append(".");
            fullBuffer.append(this.uniqueString);
            fullBuffer.append(".");
            fullBuffer.append(this.hostname);
            if (this.sizeString != null) {
                fullBuffer.append(this.sizeString);
            }
            if (this.flagsString != null) {
                fullBuffer.append(this.flagsString);
            }
            this.fullName = fullBuffer.toString();
        }
        return this.fullName;
    }

    public File getFile() throws FileNotFoundException {
        if (this.exists()) {
            return this.file;
        }
        throw new FileNotFoundException("There is no file for message name " + this.fullName + " in mailbox " + this.parentFolder.getRootFile().getAbsolutePath());
    }

    public FilenameFilter getFilenameFilter() {
        this.split();
        StringBuilder pattern = new StringBuilder();
        pattern.append(this.timestamp);
        pattern.append("\\.");
        pattern.append(this.uniqueString);
        pattern.append("\\.");
        pattern.append(this.hostname);
        pattern.append(".*");
        return MaildirMessageName.createRegexFilter(Pattern.compile(pattern.toString()));
    }

    private void split() {
        if (!this.isSplit) {
            this.splitFullName();
            this.splitHostNameAndMeta();
            this.isSplit = true;
        }
    }

    private void splitFullName() {
        int firstEnd = this.fullName.indexOf(46);
        int secondEnd = this.fullName.indexOf(46, firstEnd + 1);
        this.timestamp = this.fullName.substring(0, firstEnd);
        this.uniqueString = this.fullName.substring(firstEnd + 1, secondEnd);
        this.hostnameAndMeta = this.fullName.substring(secondEnd + 1, this.fullName.length());
    }

    private void splitHostNameAndMeta() {
        String[] hostnamemetaFlags = this.hostnameAndMeta.split(":", 2);
        if (hostnamemetaFlags.length >= 1) {
            this.hostnameAndMeta = hostnamemetaFlags[0];
            int firstEnd = this.hostnameAndMeta.indexOf(44);
            if (firstEnd > 0) {
                String[] fields;
                this.hostname = this.hostnameAndMeta.substring(0, firstEnd);
                String attrStr = this.hostnameAndMeta.substring(firstEnd);
                for (String field : fields = attrStr.split(",")) {
                    if (!field.startsWith("S=")) continue;
                    this.sizeString = "," + field;
                }
            } else {
                this.sizeString = null;
                this.hostname = this.hostnameAndMeta;
            }
        }
        if (hostnamemetaFlags.length >= 2) {
            this.flagsString = ":" + hostnamemetaFlags[1];
        }
        if (this.isMessageNameStrictParse()) {
            if (this.sizeString == null) {
                throw new IllegalArgumentException("No message size found in message name: " + this.fullName);
            }
            if (this.flagsString == null) {
                throw new IllegalArgumentException("No flags found in message name: " + this.fullName);
            }
        }
    }

    public void setFlags(Flags flags) {
        if (this.flags != flags) {
            this.split();
            this.flags = flags;
            this.flagsString = this.encodeFlags(flags);
            this.fullName = null;
        }
    }

    public Flags getFlags() {
        if (this.flags == null) {
            this.split();
            if (this.flagsString == null) {
                return null;
            }
            if (this.flagsString.length() >= 3) {
                this.flags = this.decodeFlags(this.flagsString.substring(3));
            }
        }
        return this.flags;
    }

    public Long getSize() {
        if (this.size == null) {
            this.split();
            if (this.sizeString == null) {
                return null;
            }
            if (!this.sizeString.startsWith(",S=")) {
                return null;
            }
            this.size = Long.valueOf(this.sizeString.substring(3));
        }
        return this.size;
    }

    public Date getInternalDate() {
        if (this.internalDate == null) {
            this.split();
            if (this.timestamp == null) {
                return null;
            }
            this.internalDate = new Date(Long.valueOf(this.timestamp) * 1000L);
        }
        return this.internalDate;
    }

    public String getBaseName() {
        this.split();
        StringBuilder baseName = new StringBuilder();
        baseName.append(this.timestamp);
        baseName.append(".");
        baseName.append(this.uniqueString);
        baseName.append(".");
        baseName.append(this.hostname);
        return baseName.toString();
    }

    public String encodeFlags(Flags flags) {
        StringBuilder localFlagsString = new StringBuilder(":2,");
        if (flags.contains(Flags.Flag.DRAFT)) {
            localFlagsString.append(FLAG_DRAFT);
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            localFlagsString.append(FLAG_FLAGGED);
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            localFlagsString.append(FLAG_ANSWERD);
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            localFlagsString.append(FLAG_SEEN);
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            localFlagsString.append(FLAG_DELETED);
        }
        return localFlagsString.toString();
    }

    public Flags decodeFlags(String flagsString) {
        Flags localFlags = new Flags();
        if (flagsString.contains(FLAG_DRAFT)) {
            localFlags.add(Flags.Flag.DRAFT);
        }
        if (flagsString.contains(FLAG_FLAGGED)) {
            localFlags.add(Flags.Flag.FLAGGED);
        }
        if (flagsString.contains(FLAG_ANSWERD)) {
            localFlags.add(Flags.Flag.ANSWERED);
        }
        if (flagsString.contains(FLAG_SEEN)) {
            localFlags.add(Flags.Flag.SEEN);
        }
        if (flagsString.contains(FLAG_DELETED)) {
            localFlags.add(Flags.Flag.DELETED);
        }
        return localFlags;
    }

    private static long getNextDeliveryNumber() {
        return deliveries.getAndIncrement();
    }

    public static MaildirMessageName createUniqueName(MaildirFolder parentFolder, long size) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        timestamp = timestamp.substring(0, timestamp.length() - 3);
        StringBuilder uniquePart = new StringBuilder();
        uniquePart.append(Integer.toHexString(random.nextInt()));
        uniquePart.append(timestamp.substring(timestamp.length() - 3));
        uniquePart.append(processName);
        uniquePart.append(MaildirMessageName.getNextDeliveryNumber());
        String sizeString = ",S=" + String.valueOf(size);
        String fullName = timestamp + "." + uniquePart.toString() + "." + currentHostname + sizeString;
        MaildirMessageName uniqueName = new MaildirMessageName(parentFolder, fullName);
        uniqueName.timestamp = timestamp;
        uniqueName.uniqueString = uniquePart.toString();
        uniqueName.hostname = currentHostname;
        uniqueName.sizeString = sizeString;
        uniqueName.isSplit = true;
        uniqueName.size = size;
        return uniqueName;
    }

    public static FilenameFilter createRegexFilter(final Pattern pattern) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = pattern.matcher(name);
                return matcher.matches();
            }
        };
    }

    public static String optional(String pattern) {
        return "(" + pattern + ")?";
    }

    public String toString() {
        return this.getFullName();
    }

    static {
        String[] parts = processName.split("@");
        if (parts.length > 1) {
            processName = parts[0];
        }
        try {
            currentHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            currentHostname = "localhost";
        }
    }
}

