/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.mailbox.maildir.mail.MaildirMailboxMapper;
import org.apache.james.mailbox.maildir.mail.MaildirMessageMapper;
import org.apache.james.mailbox.maildir.user.MaildirSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.NoopAttachmentMapper;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class MaildirMailboxSessionMapperFactory
extends MailboxSessionMapperFactory {
    private final MaildirStore store;

    public MaildirMailboxSessionMapperFactory(MaildirStore store) {
        this.store = store;
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) throws MailboxException {
        return new MaildirMailboxMapper(this.store, session);
    }

    public MessageMapper createMessageMapper(MailboxSession session) throws MailboxException {
        return new MaildirMessageMapper(session, this.store);
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException();
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) throws SubscriptionException {
        return new MaildirSubscriptionMapper(this.store);
    }

    public AttachmentMapper createAttachmentMapper(MailboxSession session) throws MailboxException {
        return new NoopAttachmentMapper();
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) throws MailboxException {
        throw new NotImplementedException();
    }

    public UidProvider getUidProvider() {
        throw new NotImplementedException();
    }

    public ModSeqProvider getModSeqProvider() {
        throw new NotImplementedException();
    }
}

