/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SimpleMailboxACL;

public class MaildirFolder {
    public static final String VALIDITY_FILE = "james-uidvalidity";
    public static final String UIDLIST_FILE = "james-uidlist";
    public static final String ACL_FILE = "james-acl";
    public static final String CUR = "cur";
    public static final String NEW = "new";
    public static final String TMP = "tmp";
    private final File rootFolder;
    private final File curFolder;
    private final File newFolder;
    private final File tmpFolder;
    private final File uidFile;
    private final File aclFile;
    private Optional<MessageUid> lastUid;
    private int messageCount = 0;
    private long uidValidity = -1L;
    private MailboxACL acl;
    private boolean messageNameStrictParse = false;
    private final MailboxPathLocker locker;
    private final MailboxPath path;

    public MaildirFolder(String absPath, MailboxPath path, MailboxPathLocker locker) {
        this.rootFolder = new File(absPath);
        this.curFolder = new File(this.rootFolder, CUR);
        this.newFolder = new File(this.rootFolder, NEW);
        this.tmpFolder = new File(this.rootFolder, TMP);
        this.uidFile = new File(this.rootFolder, UIDLIST_FILE);
        this.aclFile = new File(this.rootFolder, ACL_FILE);
        this.locker = locker;
        this.path = path;
        this.lastUid = Optional.absent();
    }

    private MaildirMessageName newMaildirMessageName(MaildirFolder folder, String fullName) {
        MaildirMessageName mdn = new MaildirMessageName(folder, fullName);
        mdn.setMessageNameStrictParse(this.isMessageNameStrictParse());
        return mdn;
    }

    public boolean isMessageNameStrictParse() {
        return this.messageNameStrictParse;
    }

    public void setMessageNameStrictParse(boolean messageNameStrictParse) {
        this.messageNameStrictParse = messageNameStrictParse;
    }

    public File getRootFile() {
        return this.rootFolder;
    }

    public boolean exists() {
        return this.rootFolder.isDirectory() && this.curFolder.isDirectory() && this.newFolder.isDirectory() && this.tmpFolder.isDirectory();
    }

    private boolean isModified() {
        long uidListModified = this.uidFile.lastModified();
        long curModified = this.curFolder.lastModified();
        long newModified = this.newFolder.lastModified();
        return curModified >= uidListModified || newModified >= uidListModified;
    }

    public File getCurFolder() {
        return this.curFolder;
    }

    public File getNewFolder() {
        return this.newFolder;
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }

    private MessageUid getNextUid() {
        MessageUid nextUid = (MessageUid)this.lastUid.transform((Function)new Function<MessageUid, MessageUid>(){

            public MessageUid apply(MessageUid input) {
                return input.next();
            }
        }).or((Object)MessageUid.MIN_VALUE);
        this.lastUid = Optional.of((Object)nextUid);
        return nextUid;
    }

    public Optional<MessageUid> getLastUid(MailboxSession session) throws MailboxException {
        if (!this.lastUid.isPresent()) {
            this.readLastUid(session);
        }
        return this.lastUid;
    }

    public long getHighestModSeq() throws IOException {
        long newModified = this.getNewFolder().lastModified();
        long curModified = this.getCurFolder().lastModified();
        if (newModified == 0L && curModified == 0L) {
            throw new IOException("Unable to read highest modSeq");
        }
        return Math.max(newModified, curModified);
    }

    private void readLastUid(MailboxSession session) throws MailboxException {
        this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            public Void execute() throws MailboxException {
                Void void_;
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                try {
                    String line;
                    if (!uidList.exists()) {
                        MaildirFolder.this.createUidFile();
                    }
                    if ((line = (reader = new BufferedReader(fileReader = new FileReader(uidList))).readLine()) != null) {
                        MaildirFolder.this.readUidListHeader(line);
                    }
                    void_ = null;
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to read last uid", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly(fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return void_;
            }
        }, true);
    }

    public long getUidValidity() throws IOException {
        if (this.uidValidity == -1L) {
            this.uidValidity = this.readUidValidity();
        }
        return this.uidValidity;
    }

    public void setUidValidity(long uidValidity) throws IOException {
        this.saveUidValidity(uidValidity);
        this.uidValidity = uidValidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readUidValidity() throws IOException {
        long l;
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        if (!validityFile.exists()) {
            return this.resetUidValidity();
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(validityFile);
            isr = new InputStreamReader(fis);
            char[] uidValidity = new char[20];
            int len = isr.read(uidValidity);
            l = Long.parseLong(String.valueOf(uidValidity, 0, len).trim());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUidValidity(long uidValidity) throws IOException {
        File validityFile = new File(this.rootFolder, VALIDITY_FILE);
        if (!validityFile.createNewFile()) {
            throw new IOException("Could not create file " + validityFile);
        }
        FileOutputStream fos = new FileOutputStream(validityFile);
        try {
            fos.write(String.valueOf(uidValidity).getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private long resetUidValidity() throws IOException {
        long timestamp = System.currentTimeMillis();
        this.setUidValidity(timestamp);
        return timestamp;
    }

    public MaildirMessageName getMessageNameByUid(final MailboxSession session, final MessageUid uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MaildirMessageName>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public MaildirMessageName execute() throws MailboxException {
                block7: {
                    fileReader = null;
                    reader = null;
                    uidList = MaildirFolder.access$000(MaildirFolder.this);
                    try {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        uidString = String.valueOf(uid.asLong());
                        line = reader.readLine();
                        lineNumber = 1;
                        while ((line = reader.readLine()) != null) {
                            if (line.equals("")) continue;
                            gap = line.indexOf(" ");
                            if (gap == -1) {
                                session.getLog().info("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                                continue;
                            }
                            if (!line.substring(0, gap).equals(uidString)) continue;
                            var8_10 = MaildirFolder.access$300(MaildirFolder.this, MaildirFolder.this, line.substring(gap + 1));
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            throw new MailboxException("Unable to read messagename for uid " + uid, (Throwable)e);
                        }
                        catch (Throwable var9_11) {
                            IOUtils.closeQuietly(reader);
                            IOUtils.closeQuietly((Reader)fileReader);
                            throw var9_11;
                        }
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return var8_10;
lbl-1000:
                // 1 sources

                {
                    var7_9 = null;
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return var7_9;
            }
        }, true);
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(final MailboxSession session, final MessageUid from, final MessageUid to) throws MailboxException {
        return (SortedMap)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<SortedMap<MessageUid, MaildirMessageName>>(){

            public SortedMap<MessageUid, MaildirMessageName> execute() throws MailboxException {
                TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
                File uidList = MaildirFolder.this.uidFile;
                if (uidList.isFile()) {
                    if (MaildirFolder.this.isModified()) {
                        try {
                            uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.updateUidFile(), from, to));
                        }
                        catch (MailboxException e) {
                            uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.createUidFile(), from, to));
                        }
                    } else {
                        uidMap.putAll(MaildirFolder.this.readUidFile(session, from, to));
                    }
                } else {
                    uidMap.putAll(MaildirFolder.this.truncateMap(MaildirFolder.this.createUidFile(), from, to));
                }
                return uidMap;
            }
        }, true);
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(MailboxSession session, FilenameFilter filter, MessageUid from, MessageUid to) throws MailboxException {
        SortedMap<MessageUid, MaildirMessageName> allUids = this.getUidMap(session, from, to);
        TreeMap<MessageUid, MaildirMessageName> filteredUids = new TreeMap<MessageUid, MaildirMessageName>();
        for (Map.Entry<MessageUid, MaildirMessageName> entry : allUids.entrySet()) {
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
        }
        return filteredUids;
    }

    public SortedMap<MessageUid, MaildirMessageName> getUidMap(MailboxSession session, FilenameFilter filter, int limit) throws MailboxException {
        MessageUid to = null;
        SortedMap<MessageUid, MaildirMessageName> allUids = this.getUidMap(session, MessageUid.MIN_VALUE, to);
        TreeMap<MessageUid, MaildirMessageName> filteredUids = new TreeMap<MessageUid, MaildirMessageName>();
        int theLimit = limit;
        if (limit < 1) {
            theLimit = allUids.size();
        }
        int counter = 0;
        for (Map.Entry<MessageUid, MaildirMessageName> entry : allUids.entrySet()) {
            if (counter >= theLimit) break;
            if (!filter.accept(null, entry.getValue().getFullName())) continue;
            filteredUids.put(entry.getKey(), entry.getValue());
            ++counter;
        }
        return filteredUids;
    }

    public SortedMap<MessageUid, MaildirMessageName> getRecentMessages(final MailboxSession session) throws MailboxException {
        final String[] recentFiles = this.getNewFolder().list();
        final LinkedList lines = new LinkedList();
        final int theLimit = recentFiles.length;
        return (SortedMap)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<SortedMap<MessageUid, MaildirMessageName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public SortedMap<MessageUid, MaildirMessageName> execute() throws MailboxException {
                TreeMap<MessageUid, MaildirMessageName> recentMessages = new TreeMap<MessageUid, MaildirMessageName>();
                File uidList = MaildirFolder.this.uidFile;
                try {
                    if (!uidList.isFile()) {
                        String[] allFiles;
                        if (!uidList.createNewFile()) {
                            throw new IOException("Could not create file " + uidList);
                        }
                        Object[] curFiles = MaildirFolder.this.curFolder.list();
                        Object[] newFiles = MaildirFolder.this.newFolder.list();
                        MaildirFolder.this.messageCount = curFiles.length + newFiles.length;
                        for (String file : allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles)) {
                            lines.add(String.valueOf(MaildirFolder.this.getNextUid().asLong()) + " " + file);
                        }
                        PrintWriter pw = new PrintWriter(uidList);
                        try {
                            pw.println(MaildirFolder.this.createUidListHeader());
                            for (String line : lines) {
                                pw.println(line);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Writer)pw);
                        }
                    }
                    FileReader fileReader = null;
                    BufferedReader reader = null;
                    try {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        String line = reader.readLine();
                        while ((line = reader.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    IOUtils.closeQuietly((Reader)fileReader);
                    int counter = 0;
                    block12: while (true) {
                        String line;
                        if (counter >= theLimit) return recentMessages;
                        try {
                            line = (String)lines.removeLast();
                        }
                        catch (NoSuchElementException e) {
                            return recentMessages;
                        }
                        if (line.equals("")) continue;
                        int gap = line.indexOf(" ");
                        if (gap == -1) {
                            session.getLog().info("Corrupted entry in uid-file " + uidList + " line " + lines.size());
                            continue;
                        }
                        MessageUid uid = MessageUid.of((long)Long.valueOf(line.substring(0, gap)));
                        String name = line.substring(gap + 1, line.length());
                        String[] stringArray = recentFiles;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block12;
                            String recentFile = stringArray[n2];
                            if (recentFile.equals(name)) {
                                recentMessages.put(uid, MaildirFolder.this.newMaildirMessageName(MaildirFolder.this, recentFile));
                                ++counter;
                                continue block12;
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to read recent messages", (Throwable)e);
                }
            }
        }, true);
    }

    private Map<MessageUid, MaildirMessageName> createUidFile() throws MailboxException {
        TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        PrintWriter pw = null;
        try {
            if (!uidList.createNewFile()) {
                throw new IOException("Could not create file " + uidList);
            }
            this.lastUid = Optional.absent();
            Object[] curFiles = this.curFolder.list();
            Object[] newFiles = this.newFolder.list();
            this.messageCount = curFiles.length + newFiles.length;
            String[] allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles);
            for (String file : allFiles) {
                uidMap.put(this.getNextUid(), this.newMaildirMessageName(this, file));
            }
            pw = new PrintWriter(uidList);
            pw.println(this.createUidListHeader());
            for (Map.Entry entry : uidMap.entrySet()) {
                pw.println(String.valueOf(((MessageUid)entry.getKey()).asLong()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to create uid file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        return uidMap;
    }

    private Map<MessageUid, MaildirMessageName> updateUidFile() throws MailboxException {
        TreeMap<MessageUid, MaildirMessageName> uidMap = new TreeMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        Object[] curFiles = this.curFolder.list();
        Object[] newFiles = this.newFolder.list();
        this.messageCount = curFiles.length + newFiles.length;
        HashMap<String, MessageUid> reverseUidMap = new HashMap<String, MessageUid>(this.messageCount);
        FileReader fileReader = null;
        BufferedReader reader = null;
        PrintWriter pw = null;
        try {
            fileReader = new FileReader(uidList);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    throw new MailboxException("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                }
                MessageUid uid = MessageUid.of((long)Long.valueOf(line.substring(0, gap)));
                String string = line.substring(gap + 1, line.length());
                reverseUidMap.put(MaildirFolder.stripMetaFromName(string), uid);
            }
            String[] allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles);
            for (String file : allFiles) {
                MaildirMessageName messageName = this.newMaildirMessageName(this, file);
                MessageUid uid = (MessageUid)reverseUidMap.get(messageName.getBaseName());
                if (uid == null) {
                    uid = this.getNextUid();
                }
                uidMap.put(uid, messageName);
            }
            pw = new PrintWriter(uidList);
            pw.println(this.createUidListHeader());
            for (Map.Entry entry : uidMap.entrySet()) {
                pw.println(String.valueOf(((MessageUid)entry.getKey()).asLong()) + " " + ((MaildirMessageName)entry.getValue()).getFullName());
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to update uid file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pw);
                IOUtils.closeQuietly((Reader)fileReader);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)reader);
        return uidMap;
    }

    private Map<MessageUid, MaildirMessageName> readUidFile(MailboxSession session, MessageUid from, MessageUid to) throws MailboxException {
        HashMap<MessageUid, MaildirMessageName> uidMap = new HashMap<MessageUid, MaildirMessageName>();
        File uidList = this.uidFile;
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(uidList);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            if (line != null) {
                this.readUidListHeader(line);
            }
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                int gap = line.indexOf(" ");
                if (gap == -1) {
                    session.getLog().info("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                    continue;
                }
                MessageUid uid = MessageUid.of((long)Long.valueOf(line.substring(0, gap)));
                if (uid.compareTo(from) < 0) continue;
                if (to != null && uid.compareTo(to) > 0) break;
                String name = line.substring(gap + 1, line.length());
                uidMap.put(uid, this.newMaildirMessageName(this, name));
            }
        }
        catch (IOException e) {
            try {
                throw new MailboxException("Unable to read uid file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((Reader)fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)fileReader);
        this.messageCount = uidMap.size();
        return uidMap;
    }

    private SortedMap<MessageUid, MaildirMessageName> truncateMap(Map<MessageUid, MaildirMessageName> map, MessageUid from, MessageUid to) {
        TreeMap<MessageUid, MaildirMessageName> sortedMap = map instanceof TreeMap ? (TreeMap<MessageUid, MaildirMessageName>)map : new TreeMap<MessageUid, MaildirMessageName>(map);
        if (to != null) {
            return sortedMap.subMap(from, to.next());
        }
        return sortedMap.tailMap(from);
    }

    private void readUidListHeader(String line) throws IOException {
        if (line == null) {
            throw new IOException("Header entry in uid-file is null");
        }
        int gap1 = line.indexOf(" ");
        if (gap1 == -1) {
            throw new IOException("Corrupted header entry in uid-file");
        }
        int version = Integer.valueOf(line.substring(0, gap1));
        if (version != 1) {
            throw new IOException("Cannot read uidlists with versions other than 1.");
        }
        int gap2 = line.indexOf(" ", gap1 + 1);
        this.lastUid = Optional.of((Object)MessageUid.of((long)Long.valueOf(line.substring(gap1 + 1, gap2))));
        this.messageCount = Integer.valueOf(line.substring(gap2 + 1, line.length()));
    }

    private String createUidListHeader() {
        Long last = (Long)this.lastUid.transform((Function)new Function<MessageUid, Long>(){

            public Long apply(MessageUid input) {
                return input.asLong();
            }
        }).or((Object)0L);
        return "1 " + String.valueOf(last) + " " + String.valueOf(this.messageCount);
    }

    public static String stripMetaFromName(String fileName) {
        int end = fileName.indexOf(",S=");
        if (end == -1) {
            end = fileName.indexOf(":2,");
        }
        if (end == -1) {
            return fileName;
        }
        return fileName.substring(0, end);
    }

    public MessageUid appendMessage(MailboxSession session, final String name) throws MailboxException {
        return (MessageUid)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MessageUid>(){

            public MessageUid execute() throws MailboxException {
                File uidList = MaildirFolder.this.uidFile;
                MessageUid uid = null;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter pw = null;
                try {
                    if (uidList.isFile()) {
                        fileReader = new FileReader(uidList);
                        reader = new BufferedReader(fileReader);
                        String line = reader.readLine();
                        if (line != null) {
                            MaildirFolder.this.readUidListHeader(line);
                        }
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            lines.add(line);
                        }
                        uid = MaildirFolder.this.getNextUid();
                        lines.add(String.valueOf(uid.asLong()) + " " + name);
                        MaildirFolder.this.messageCount++;
                        pw = new PrintWriter(uidList);
                        pw.println(MaildirFolder.this.createUidListHeader());
                        for (String entry : lines) {
                            pw.println(entry);
                        }
                    } else {
                        if (!uidList.createNewFile()) {
                            throw new IOException("Could not create file " + uidList);
                        }
                        Object[] curFiles = MaildirFolder.this.curFolder.list();
                        Object[] newFiles = MaildirFolder.this.newFolder.list();
                        MaildirFolder.this.messageCount = curFiles.length + newFiles.length;
                        ArrayList<String> lines = new ArrayList<String>();
                        String[] allFiles = (String[])ArrayUtils.addAll((Object[])curFiles, (Object[])newFiles);
                        for (String file : allFiles) {
                            MessageUid theUid = MaildirFolder.this.getNextUid();
                            lines.add(String.valueOf(theUid.asLong()) + " " + file);
                            if (!file.equals(name)) continue;
                            uid = theUid;
                        }
                        pw = new PrintWriter(uidList);
                        pw.println(MaildirFolder.this.createUidListHeader());
                        for (String line : lines) {
                            pw.println(line);
                        }
                    }
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to append msg", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(pw);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)pw);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                if (uid == null) {
                    throw new MailboxException("Unable to append msg");
                }
                return uid;
            }
        }, true);
    }

    public void update(MailboxSession session, final MessageUid uid, final String messageName) throws MailboxException {
        this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            public Void execute() throws MailboxException {
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter writer = null;
                try {
                    fileReader = new FileReader(uidList);
                    reader = new BufferedReader(fileReader);
                    String line = reader.readLine();
                    MaildirFolder.this.readUidListHeader(line);
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        if (uid.equals((Object)MessageUid.of((long)Long.valueOf(line.substring(0, line.indexOf(" ")))))) {
                            line = String.valueOf(uid.asLong()) + " " + messageName;
                        }
                        lines.add(line);
                    }
                    writer = new PrintWriter(uidList);
                    writer.println(MaildirFolder.this.createUidListHeader());
                    for (String entry : lines) {
                        writer.println(entry);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to update msg with uid " + uid, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)writer);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return null;
            }
        }, true);
    }

    public MaildirMessageName delete(final MailboxSession session, final MessageUid uid) throws MailboxException {
        return (MaildirMessageName)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MaildirMessageName>(){

            public MaildirMessageName execute() throws MailboxException {
                MaildirMessageName maildirMessageName;
                File uidList = MaildirFolder.this.uidFile;
                FileReader fileReader = null;
                BufferedReader reader = null;
                PrintWriter writer = null;
                MaildirMessageName deletedMessage = null;
                try {
                    String line;
                    fileReader = new FileReader(uidList);
                    reader = new BufferedReader(fileReader);
                    MaildirFolder.this.readUidListHeader(reader.readLine());
                    ArrayList<String> lines = new ArrayList<String>();
                    int lineNumber = 1;
                    while ((line = reader.readLine()) != null) {
                        int gap = line.indexOf(" ");
                        if (gap == -1) {
                            session.getLog().info("Corrupted entry in uid-file " + uidList + " line " + lineNumber++);
                            continue;
                        }
                        if (uid.equals((Object)MessageUid.of((long)Long.valueOf(line.substring(0, line.indexOf(" ")))))) {
                            deletedMessage = MaildirFolder.this.newMaildirMessageName(MaildirFolder.this, line.substring(gap + 1, line.length()));
                            MaildirFolder.this.messageCount--;
                            continue;
                        }
                        lines.add(line);
                    }
                    if (deletedMessage != null) {
                        FileUtils.forceDelete((File)deletedMessage.getFile());
                        writer = new PrintWriter(uidList);
                        writer.println(MaildirFolder.this.createUidListHeader());
                        for (String entry : lines) {
                            writer.println(entry);
                        }
                    }
                    maildirMessageName = deletedMessage;
                }
                catch (IOException e) {
                    try {
                        throw new MailboxException("Unable to delete msg with uid " + uid, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((Reader)fileReader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Reader)fileReader);
                return maildirMessageName;
            }
        }, true);
    }

    public String toString() {
        return this.getRootFile().getAbsolutePath();
    }

    public MailboxACL getACL(MailboxSession session) throws MailboxException {
        if (this.acl == null) {
            this.acl = this.readACL(session);
        }
        return this.acl;
    }

    private MailboxACL readACL(MailboxSession session) throws MailboxException {
        return (MailboxACL)this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<MailboxACL>(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public MailboxACL execute() throws MailboxException {
                File f = MaildirFolder.this.aclFile;
                FileInputStream in = null;
                Properties props = new Properties();
                if (!f.exists()) return new SimpleMailboxACL(props);
                try {
                    in = new FileInputStream(f);
                    props.load(in);
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e);
                        catch (IOException e2) {
                            throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                return new SimpleMailboxACL(props);
            }
        }, true);
    }

    public void setACL(MailboxSession session, MailboxACL acl) throws MailboxException {
        MailboxACL old = this.acl;
        if (!(old == acl || old != null && old.equals(acl))) {
            this.saveACL(acl, session);
            this.acl = acl;
        }
    }

    private void saveACL(final MailboxACL acl, MailboxSession session) throws MailboxException {
        this.locker.executeWithLock(session, this.path, (MailboxPathLocker.LockAwareExecution)new MailboxPathLocker.LockAwareExecution<Void>(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void execute() throws MailboxException {
                File f = MaildirFolder.this.aclFile;
                FileOutputStream out = null;
                Properties props = new Properties();
                Map entries = acl.getEntries();
                if (entries != null) {
                    for (Map.Entry en : entries.entrySet()) {
                        props.put(((MailboxACL.MailboxACLEntryKey)en.getKey()).serialize(), ((MailboxACL.MailboxACLRights)en.getValue()).serialize());
                    }
                }
                if (!f.exists()) return null;
                try {
                    out = new FileOutputStream(f);
                    props.store(out, "written by " + this.getClass().getName());
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e);
                        catch (IOException e2) {
                            throw new MailboxException("Unable to read last ACL from " + f.getAbsolutePath(), (Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)out);
                return null;
            }
        }, true);
    }
}

