/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.transaction;

import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.store.transaction.Mapper;

public abstract class TransactionalMapper
implements Mapper {
    @Override
    public final <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        this.begin();
        try {
            T value = transaction.run();
            this.commit();
            return value;
        }
        catch (MailboxException e) {
            this.rollback();
            throw e;
        }
    }

    protected abstract void begin() throws MailboxException;

    protected abstract void commit() throws MailboxException;

    protected abstract void rollback() throws MailboxException;
}

