/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.store.mail.model.Message;

public final class InputStreamContent
implements Content {
    private final Message m;
    private final Type type;

    public InputStreamContent(Message m, Type type) throws IOException {
        this.m = m;
        this.type = type;
    }

    public long size() {
        switch (this.type) {
            case Full: {
                return this.m.getFullContentOctets();
            }
        }
        return this.m.getBodyOctets();
    }

    public InputStream getInputStream() throws IOException {
        switch (this.type) {
            case Full: {
                return this.m.getFullContent();
            }
        }
        return this.m.getBodyContent();
    }

    public static enum Type {
        Full,
        Body;

    }
}

