/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.List;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageResult;

public class FullByteContent
implements Content {
    private final List<MessageResult.Header> headers;
    private final byte[] body;
    private final long size;

    public FullByteContent(byte[] body, List<MessageResult.Header> headers) throws MailboxException {
        this.headers = headers;
        this.body = body;
        this.size = this.caculateSize();
    }

    protected long caculateSize() throws MailboxException {
        long result = this.body.length;
        result += 2L;
        for (MessageResult.Header header : this.headers) {
            if (header == null) continue;
            result += header.size();
            result += 2L;
        }
        return result;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (MessageResult.Header header : this.headers) {
            if (header == null) continue;
            try {
                out.write((header.getName() + ": " + header.getValue() + "\r\n").getBytes("US-ASCII"));
            }
            catch (MailboxException e) {
                throw new IOException("Unable to read headers", e);
            }
        }
        out.write("\r\n".getBytes("US-ASCII"));
        out.flush();
        return new SequenceInputStream(new ByteArrayInputStream(out.toByteArray()), new ByteArrayInputStream(this.body));
    }

    public long size() {
        return this.size;
    }
}

