/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.Date;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;
import org.apache.james.mailbox.store.search.comparator.UidComparator;
import org.apache.james.mime4j.dom.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;

public class SentDateComparator
extends AbstractHeaderComparator {
    public static final Comparator<MailboxMessage> SENTDATE = new SentDateComparator();

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        Date date2;
        Date date1 = this.getSentDate(o1);
        int i = date1.compareTo(date2 = this.getSentDate(o2));
        if (i == 0) {
            return UidComparator.UID.compare(o1, o2);
        }
        return 0;
    }

    private Date getSentDate(MailboxMessage message) {
        String value = this.getHeaderValue("Date", message);
        StringReader reader = new StringReader(value);
        try {
            DateTime dateTime = new DateTimeParser((Reader)reader).parseAll();
            return dateTime.getDate();
        }
        catch (ParseException e) {
            return message.getInternalDate();
        }
    }
}

