/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.comparator.BaseSubjectComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderDisplayComparator;
import org.apache.james.mailbox.store.search.comparator.HeaderMailboxComparator;
import org.apache.james.mailbox.store.search.comparator.InternalDateComparator;
import org.apache.james.mailbox.store.search.comparator.MessageIdComparator;
import org.apache.james.mailbox.store.search.comparator.ReverseComparator;
import org.apache.james.mailbox.store.search.comparator.SentDateComparator;
import org.apache.james.mailbox.store.search.comparator.SizeComparator;
import org.apache.james.mailbox.store.search.comparator.UidComparator;

public class CombinedComparator
implements Comparator<MailboxMessage> {
    private final List<Comparator<MailboxMessage>> comparators;

    public static CombinedComparator create(List<SearchQuery.Sort> sorts) {
        Preconditions.checkNotNull(sorts);
        Preconditions.checkArgument((!sorts.isEmpty() ? 1 : 0) != 0);
        return new CombinedComparator((List<Comparator<MailboxMessage>>)FluentIterable.from(sorts).transform(CombinedComparator.toComparator()).toList());
    }

    private static Function<SearchQuery.Sort, Comparator<MailboxMessage>> toComparator() {
        return new Function<SearchQuery.Sort, Comparator<MailboxMessage>>(){

            public Comparator<MailboxMessage> apply(SearchQuery.Sort input) {
                return CombinedComparator.optionalResverse(CombinedComparator.toComparator(input), input.isReverse());
            }
        };
    }

    private static Comparator<MailboxMessage> toComparator(SearchQuery.Sort sort) {
        switch (sort.getSortClause()) {
            case Arrival: {
                return InternalDateComparator.INTERNALDATE;
            }
            case MailboxCc: {
                return HeaderMailboxComparator.CC_COMPARATOR;
            }
            case MailboxFrom: {
                return HeaderMailboxComparator.FROM_COMPARATOR;
            }
            case Size: {
                return SizeComparator.SIZE;
            }
            case BaseSubject: {
                return BaseSubjectComparator.BASESUBJECT;
            }
            case MailboxTo: {
                return HeaderMailboxComparator.TO_COMPARATOR;
            }
            case Uid: {
                return UidComparator.UID;
            }
            case SentDate: {
                return SentDateComparator.SENTDATE;
            }
            case DisplayFrom: {
                return HeaderDisplayComparator.FROM_COMPARATOR;
            }
            case DisplayTo: {
                return HeaderDisplayComparator.TO_COMPARATOR;
            }
            case Id: {
                return MessageIdComparator.MESSAGE_ID_COMPARATOR;
            }
        }
        throw new NotImplementedException("Combined comparator does not support sort " + sort.getSortClause());
    }

    private static Comparator<MailboxMessage> optionalResverse(Comparator<MailboxMessage> comparator, boolean isReverse) {
        if (isReverse) {
            return new ReverseComparator(comparator);
        }
        return comparator;
    }

    public List<Comparator<MailboxMessage>> getComparators() {
        return this.comparators;
    }

    private CombinedComparator(List<Comparator<MailboxMessage>> comparators) {
        this.comparators = comparators;
    }

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        Comparator<MailboxMessage> comparator;
        int i = 0;
        Iterator<Comparator<MailboxMessage>> iterator = this.comparators.iterator();
        while (iterator.hasNext() && (i = (comparator = iterator.next()).compare(o1, o2)) == 0) {
        }
        return i;
    }
}

