/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearches;
import org.apache.james.mailbox.store.search.SearchUtil;

public class SimpleMessageSearchIndex
implements MessageSearchIndex {
    private static final String WILDCARD = "%";
    private final MessageMapperFactory messageMapperFactory;
    private final MailboxMapperFactory mailboxMapperFactory;

    @Inject
    public SimpleMessageSearchIndex(MessageMapperFactory messageMapperFactory, MailboxMapperFactory mailboxMapperFactory) {
        this.messageMapperFactory = messageMapperFactory;
        this.mailboxMapperFactory = mailboxMapperFactory;
    }

    @Override
    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities() {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, MailboxManager.SearchCapabilities.Text);
    }

    private static SearchQuery.UidCriterion findConjugatedUidCriterion(List<SearchQuery.Criterion> crits) {
        for (SearchQuery.Criterion crit : crits) {
            if (crit instanceof SearchQuery.UidCriterion) {
                return (SearchQuery.UidCriterion)crit;
            }
            if (!(crit instanceof SearchQuery.ConjunctionCriterion)) continue;
            return SimpleMessageSearchIndex.findConjugatedUidCriterion(((SearchQuery.ConjunctionCriterion)crit).getCriteria());
        }
        return null;
    }

    @Override
    public Iterator<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery query) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return FluentIterable.from(this.searchResults(session, (Iterable<Mailbox>)ImmutableList.of((Object)mailbox), query)).filter(this.isInMailbox(mailbox)).transform(this.toMessageUid()).iterator();
    }

    private List<MessageSearchIndex.SearchResult> searchResults(MailboxSession session, Iterable<Mailbox> mailboxes, SearchQuery query) throws MailboxException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Mailbox mailbox : mailboxes) {
            builder.addAll(this.searchResults(session, mailbox, query));
        }
        return builder.build();
    }

    private List<MessageSearchIndex.SearchResult> searchResults(MailboxSession session, Mailbox mailbox, SearchQuery query) throws MailboxException {
        if (!this.isMatchingUser(session, mailbox)) {
            return ImmutableList.of();
        }
        MessageMapper mapper = this.messageMapperFactory.getMessageMapper(session);
        TreeSet<MailboxMessage> hitSet = new TreeSet<MailboxMessage>();
        SearchQuery.UidCriterion uidCrit = SimpleMessageSearchIndex.findConjugatedUidCriterion(query.getCriterias());
        if (uidCrit != null) {
            SearchQuery.UidRange[] ranges;
            for (SearchQuery.UidRange r : ranges = uidCrit.getOperator().getRange()) {
                Iterator<MailboxMessage> it = mapper.findInMailbox(mailbox, MessageRange.range((MessageUid)r.getLowValue(), (MessageUid)r.getHighValue()), MessageMapper.FetchType.Metadata, -1);
                while (it.hasNext()) {
                    hitSet.add(it.next());
                }
            }
        } else {
            Iterator<MailboxMessage> messages = mapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, -1);
            while (messages.hasNext()) {
                MailboxMessage m = messages.next();
                hitSet.add(m);
            }
        }
        return ImmutableList.copyOf(new MessageSearches(hitSet.iterator(), query, session).iterator());
    }

    private boolean isMatchingUser(MailboxSession session, Mailbox mailbox) {
        return mailbox.getUser().equals(session.getUser().getUserName());
    }

    @Override
    public List<MessageId> search(MailboxSession session, MultimailboxesSearchQuery searchQuery, long limit) throws MailboxException {
        List<Mailbox> allUserMailboxes = this.mailboxMapperFactory.getMailboxMapper(session).findMailboxWithPathLike(new MailboxPath(session.getPersonalSpace(), session.getUser().getUserName(), WILDCARD));
        FluentIterable filteredMailboxes = FluentIterable.from(allUserMailboxes).filter(this.notInMailboxes((Set<MailboxId>)searchQuery.getNotInMailboxes()));
        if (searchQuery.getInMailboxes().isEmpty()) {
            return this.getAsMessageIds(this.searchResults(session, (Iterable<Mailbox>)filteredMailboxes, searchQuery.getSearchQuery()), limit);
        }
        ArrayList<Mailbox> queriedMailboxes = new ArrayList<Mailbox>();
        for (Mailbox mailbox : filteredMailboxes) {
            if (!searchQuery.getInMailboxes().contains((Object)mailbox.getMailboxId())) continue;
            queriedMailboxes.add(mailbox);
        }
        return this.getAsMessageIds(this.searchResults(session, queriedMailboxes, searchQuery.getSearchQuery()), limit);
    }

    private Predicate<Mailbox> notInMailboxes(final Set<MailboxId> mailboxIds) {
        return new Predicate<Mailbox>(){

            public boolean apply(Mailbox input) {
                return !mailboxIds.contains(input.getMailboxId());
            }
        };
    }

    private List<MessageId> getAsMessageIds(List<MessageSearchIndex.SearchResult> temp, long limit) {
        return FluentIterable.from(temp).transform(this.toMessageId()).filter(SearchUtil.distinct()).limit(Long.valueOf(limit).intValue()).toList();
    }

    private Function<MessageSearchIndex.SearchResult, MessageId> toMessageId() {
        return new Function<MessageSearchIndex.SearchResult, MessageId>(){

            public MessageId apply(MessageSearchIndex.SearchResult input) {
                return (MessageId)input.getMessageId().get();
            }
        };
    }

    private Function<MessageSearchIndex.SearchResult, MessageUid> toMessageUid() {
        return new Function<MessageSearchIndex.SearchResult, MessageUid>(){

            public MessageUid apply(MessageSearchIndex.SearchResult input) {
                return input.getMessageUid();
            }
        };
    }

    private Predicate<MessageSearchIndex.SearchResult> isInMailbox(final Mailbox mailbox) {
        return new Predicate<MessageSearchIndex.SearchResult>(){

            public boolean apply(MessageSearchIndex.SearchResult input) {
                return input.getMailboxId().equals(mailbox.getMailboxId());
            }
        };
    }
}

