/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import java.util.Iterator;
import java.util.List;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public abstract class ListeningMessageSearchIndex
implements MessageSearchIndex,
MailboxListener {
    private final MessageMapperFactory factory;

    public ListeningMessageSearchIndex(MessageMapperFactory factory) {
        this.factory = factory;
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.ASYNCHRONOUS;
    }

    protected MessageMapperFactory getFactory() {
        return this.factory;
    }

    public void event(MailboxListener.Event event) {
        MailboxSession session = event.getSession();
        try {
            if (event instanceof MailboxListener.MessageEvent) {
                if (event instanceof EventFactory.AddedImpl) {
                    EventFactory.AddedImpl added = (EventFactory.AddedImpl)event;
                    Mailbox mailbox = added.getMailbox();
                    for (MessageUid next : added.getUids()) {
                        Iterator<MailboxMessage> messages = this.factory.getMessageMapper(session).findInMailbox(mailbox, MessageRange.one((MessageUid)next), MessageMapper.FetchType.Full, -1);
                        while (messages.hasNext()) {
                            MailboxMessage message = messages.next();
                            try {
                                this.add(session, mailbox, message);
                            }
                            catch (MailboxException e) {
                                session.getLog().debug("Unable to index message " + message.getUid() + " for mailbox " + mailbox, (Throwable)e);
                            }
                        }
                    }
                } else if (event instanceof EventFactory.ExpungedImpl) {
                    EventFactory.ExpungedImpl expunged = (EventFactory.ExpungedImpl)event;
                    try {
                        this.delete(session, expunged.getMailbox(), expunged.getUids());
                    }
                    catch (MailboxException e) {
                        session.getLog().debug("Unable to deleted messages " + expunged.getUids() + " from index for mailbox " + expunged.getMailbox(), (Throwable)e);
                    }
                } else if (event instanceof EventFactory.FlagsUpdatedImpl) {
                    EventFactory.FlagsUpdatedImpl flagsUpdated = (EventFactory.FlagsUpdatedImpl)event;
                    Mailbox mailbox = flagsUpdated.getMailbox();
                    try {
                        this.update(session, mailbox, flagsUpdated.getUpdatedFlags());
                    }
                    catch (MailboxException e) {
                        session.getLog().debug("Unable to update flags in index for mailbox " + mailbox, (Throwable)e);
                    }
                }
            } else if (event instanceof EventFactory.MailboxDeletionImpl) {
                this.deleteAll(session, ((EventFactory.MailboxDeletionImpl)event).getMailbox());
            }
        }
        catch (MailboxException e) {
            session.getLog().debug("Unable to update index", (Throwable)e);
        }
    }

    public abstract void add(MailboxSession var1, Mailbox var2, MailboxMessage var3) throws MailboxException;

    public abstract void delete(MailboxSession var1, Mailbox var2, List<MessageUid> var3) throws MailboxException;

    public abstract void deleteAll(MailboxSession var1, Mailbox var2) throws MailboxException;

    public abstract void update(MailboxSession var1, Mailbox var2, List<UpdatedFlags> var3) throws MailboxException;
}

