/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedSearchException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;

public class LazyMessageSearchIndex
extends ListeningMessageSearchIndex {
    private final ListeningMessageSearchIndex index;
    private final ConcurrentHashMap<MailboxId, Object> indexed = new ConcurrentHashMap();

    public LazyMessageSearchIndex(ListeningMessageSearchIndex index) {
        super(index.getFactory());
        this.index = index;
    }

    public MailboxListener.ListenerType getType() {
        return this.index.getType();
    }

    @Override
    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities() {
        return EnumSet.noneOf(MailboxManager.SearchCapabilities.class);
    }

    @Override
    public void add(MailboxSession session, Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.index.add(session, mailbox, message);
    }

    @Override
    public void delete(MailboxSession session, Mailbox mailbox, List<MessageUid> expungedUids) throws MailboxException {
        this.index.delete(session, mailbox, expungedUids);
    }

    @Override
    public void deleteAll(MailboxSession session, Mailbox mailbox) throws MailboxException {
        this.index.deleteAll(session, mailbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        MailboxId id = mailbox.getMailboxId();
        Object done = this.indexed.get(id);
        if (done == null) {
            done = new Object();
            Object oldDone = this.indexed.putIfAbsent(id, done);
            if (oldDone != null) {
                done = oldDone;
            }
            Object object = done;
            synchronized (object) {
                Iterator<MailboxMessage> messages = this.getFactory().getMessageMapper(session).findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Full, -1);
                while (messages.hasNext()) {
                    MailboxMessage message = messages.next();
                    try {
                        this.add(session, mailbox, message);
                    }
                    catch (MailboxException e) {
                        session.getLog().debug("Unable to index message " + message.getUid() + " in mailbox " + mailbox.getName(), (Throwable)e);
                    }
                }
            }
        }
        return this.index.search(session, mailbox, searchQuery);
    }

    @Override
    public void update(MailboxSession session, Mailbox mailbox, List<UpdatedFlags> updatedFlagsList) throws MailboxException {
        this.index.update(session, mailbox, updatedFlagsList);
    }

    @Override
    public List<MessageId> search(MailboxSession session, MultimailboxesSearchQuery searchQuery, long limit) throws MailboxException {
        throw new UnsupportedSearchException();
    }
}

