/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import javax.inject.Inject;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.store.quota.QuotaImpl;

public class StoreQuotaManager
implements QuotaManager {
    private CurrentQuotaManager currentQuotaManager;
    private MaxQuotaManager maxQuotaManager;
    private boolean calculateWhenUnlimited = false;

    public void setCalculateWhenUnlimited(boolean calculateWhenUnlimited) {
        this.calculateWhenUnlimited = calculateWhenUnlimited;
    }

    @Inject
    public void setMaxQuotaManager(MaxQuotaManager maxQuotaManager) {
        this.maxQuotaManager = maxQuotaManager;
    }

    @Inject
    public void setCurrentQuotaManager(CurrentQuotaManager currentQuotaManager) {
        this.currentQuotaManager = currentQuotaManager;
    }

    public Quota getMessageQuota(QuotaRoot quotaRoot) throws MailboxException {
        long maxValue = this.maxQuotaManager.getMaxMessage(quotaRoot);
        if (maxValue == -1L && !this.calculateWhenUnlimited) {
            return QuotaImpl.quota(Long.MIN_VALUE, -1L);
        }
        return QuotaImpl.quota(this.currentQuotaManager.getCurrentMessageCount(quotaRoot), maxValue);
    }

    public Quota getStorageQuota(QuotaRoot quotaRoot) throws MailboxException {
        long maxValue = this.maxQuotaManager.getMaxStorage(quotaRoot);
        if (maxValue == -1L && !this.calculateWhenUnlimited) {
            return QuotaImpl.quota(Long.MIN_VALUE, -1L);
        }
        return QuotaImpl.quota(this.currentQuotaManager.getCurrentStorage(quotaRoot), maxValue);
    }
}

