/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.james.mailbox.model.Quota;

public final class QuotaImpl
implements Quota {
    private static final Quota UNLIMITED_QUOTA = new QuotaImpl(Long.MIN_VALUE, -1L);
    private final long max;
    private long used;

    public static Quota unlimited() {
        return UNLIMITED_QUOTA;
    }

    public static Quota quota(long used, long max) {
        return new QuotaImpl(used, max);
    }

    private QuotaImpl(long used, long max) {
        this.used = used;
        this.max = max;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsed() {
        return this.used;
    }

    public void addValueToQuota(long value) {
        this.used += value;
    }

    public boolean isOverQuota() {
        return this.isOverQuotaWithAdditionalValue(0L);
    }

    public String toString() {
        return this.used + "/" + this.max;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Quota)) {
            return false;
        }
        Quota other = (Quota)o;
        return this.used == other.getUsed() && this.max == other.getMax();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.used, this.max});
    }

    public boolean isOverQuotaWithAdditionalValue(long additionalValue) {
        Preconditions.checkArgument((additionalValue >= 0L ? 1 : 0) != 0);
        return this.max != -1L && this.used + additionalValue > this.max;
    }
}

