/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class QuotaChecker {
    private final Quota messageQuota;
    private final Quota sizeQuota;
    private final QuotaRoot quotaRoot;

    public QuotaChecker(QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, Mailbox mailbox) throws MailboxException {
        this.quotaRoot = quotaRootResolver.getQuotaRoot(mailbox.generateAssociatedPath());
        this.messageQuota = quotaManager.getMessageQuota(this.quotaRoot);
        this.sizeQuota = quotaManager.getStorageQuota(this.quotaRoot);
    }

    public QuotaChecker(Quota messageQuota, Quota sizeQuota, QuotaRoot quotaRoot) {
        this.messageQuota = messageQuota;
        this.sizeQuota = sizeQuota;
        this.quotaRoot = quotaRoot;
    }

    public boolean tryAddition(long count, long size) throws OverQuotaException {
        this.messageQuota.addValueToQuota(count);
        this.sizeQuota.addValueToQuota(size);
        return this.check();
    }

    private boolean check() throws OverQuotaException {
        if (this.messageQuota.isOverQuota()) {
            throw new OverQuotaException("You have too many messages in " + this.quotaRoot.getValue(), this.messageQuota.getMax(), this.messageQuota.getUsed());
        }
        if (this.sizeQuota.isOverQuota()) {
            throw new OverQuotaException("You use too much space in " + this.quotaRoot.getValue(), this.sizeQuota.getMax(), this.sizeQuota.getUsed());
        }
        return true;
    }
}

