/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.quota.QuotaUpdater;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;

public class ListeningCurrentQuotaUpdater
implements MailboxListener,
QuotaUpdater {
    private StoreCurrentQuotaManager currentQuotaManager;
    private QuotaRootResolver quotaRootResolver;

    @Inject
    public void setQuotaRootResolver(QuotaRootResolver quotaRootResolver) {
        this.quotaRootResolver = quotaRootResolver;
    }

    @Inject
    public void setCurrentQuotaManager(StoreCurrentQuotaManager currentQuotaManager) {
        this.currentQuotaManager = currentQuotaManager;
    }

    public MailboxListener.ListenerType getType() {
        return this.currentQuotaManager.getAssociatedListenerType();
    }

    public MailboxListener.ExecutionMode getExecutionMode() {
        return MailboxListener.ExecutionMode.ASYNCHRONOUS;
    }

    public void event(MailboxListener.Event event) {
        try {
            QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(event.getMailboxPath());
            if (event instanceof MailboxListener.Added) {
                this.handleAddedEvent((MailboxListener.Added)event, quotaRoot);
            } else if (event instanceof MailboxListener.Expunged) {
                this.handleExpungedEvent((MailboxListener.Expunged)event, quotaRoot);
            }
        }
        catch (MailboxException e) {
            event.getSession().getLog().error("Error while updating quotas", (Throwable)e);
        }
    }

    private void handleExpungedEvent(MailboxListener.Expunged expunged, QuotaRoot quotaRoot) throws MailboxException {
        long addedSize = 0L;
        long addedCount = 0L;
        List uids = expunged.getUids();
        for (MessageUid uid : uids) {
            addedSize += expunged.getMetaData(uid).getSize();
            ++addedCount;
        }
        if (addedCount != 0L && addedSize != 0L) {
            this.currentQuotaManager.decrease(quotaRoot, addedCount, addedSize);
        }
    }

    private void handleAddedEvent(MailboxListener.Added added, QuotaRoot quotaRoot) throws MailboxException {
        long addedSize = 0L;
        long addedCount = 0L;
        List uids = added.getUids();
        for (MessageUid uid : uids) {
            addedSize += added.getMetaData(uid).getSize();
            ++addedCount;
        }
        if (addedCount != 0L && addedSize != 0L) {
            this.currentQuotaManager.increase(quotaRoot, addedCount, addedSize);
        }
    }
}

