/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.quota.QuotaRootImpl;

public class DefaultQuotaRootResolver
implements QuotaRootResolver {
    public static final String SEPARATOR = "&";
    private final MailboxSessionMapperFactory factory;

    @Inject
    public DefaultQuotaRootResolver(MailboxSessionMapperFactory factory) {
        this.factory = factory;
    }

    public QuotaRoot createQuotaRoot(String quotaRootValue) {
        return QuotaRootImpl.quotaRoot(quotaRootValue);
    }

    public QuotaRoot getQuotaRoot(MailboxPath mailboxPath) throws MailboxException {
        Preconditions.checkArgument((!mailboxPath.getNamespace().contains(SEPARATOR) ? 1 : 0) != 0, (Object)"Namespace should not contain &");
        Preconditions.checkArgument((!mailboxPath.getUser().contains(SEPARATOR) ? 1 : 0) != 0, (Object)"Username should not contain &");
        return QuotaRootImpl.quotaRoot(mailboxPath.getNamespace() + SEPARATOR + mailboxPath.getUser());
    }

    public List<MailboxPath> retrieveAssociatedMailboxes(QuotaRoot quotaRoot, MailboxSession mailboxSession) throws MailboxException {
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)SEPARATOR).split((CharSequence)quotaRoot.getValue()));
        if (parts.size() != 2) {
            throw new MailboxException(quotaRoot + " used as QuotaRoot should not contain 2 \"" + SEPARATOR + "\"");
        }
        String namespace = (String)parts.get(0);
        String user = (String)parts.get(1);
        return Lists.transform(this.factory.getMailboxMapper(mailboxSession).findMailboxWithPathLike(new MailboxPath(namespace, user, "%")), (Function)new Function<Mailbox, MailboxPath>(){

            public MailboxPath apply(Mailbox idMailbox) {
                return idMailbox.generateAssociatedPath();
            }
        });
    }
}

