/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class CurrentQuotaCalculator {
    private final MailboxSessionMapperFactory factory;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public CurrentQuotaCalculator(MailboxSessionMapperFactory factory, QuotaRootResolver quotaRootResolver) {
        this.factory = factory;
        this.quotaRootResolver = quotaRootResolver;
    }

    public CurrentQuotas recalculateCurrentQuotas(QuotaRoot quotaRoot, MailboxSession session) throws MailboxException {
        List<Mailbox> mailboxes = this.retrieveMailboxes(quotaRoot, session);
        MessageMapper mapper = this.factory.getMessageMapper(session);
        long messagesSizes = 0L;
        long messageCount = 0L;
        for (Mailbox mailbox : mailboxes) {
            Iterator<MailboxMessage> messages = mapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Metadata, -1);
            messageCount += mapper.countMessagesInMailbox(mailbox);
            while (messages.hasNext()) {
                messagesSizes += messages.next().getFullContentOctets();
            }
        }
        return new CurrentQuotas(messageCount, messagesSizes);
    }

    private List<Mailbox> retrieveMailboxes(QuotaRoot quotaRoot, MailboxSession session) throws MailboxException {
        List paths = this.quotaRootResolver.retrieveAssociatedMailboxes(quotaRoot, session);
        final MailboxMapper mapper = this.factory.getMailboxMapper(session);
        return Lists.transform((List)paths, (Function)new Function<MailboxPath, Mailbox>(){

            public Mailbox apply(MailboxPath mailboxPath) {
                try {
                    return mapper.findMailboxByPath(mailboxPath);
                }
                catch (MailboxException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public static class CurrentQuotas {
        private final long count;
        private final long size;

        public CurrentQuotas(long count, long size) {
            this.count = count;
            this.size = size;
        }

        public long getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }
    }
}

