/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import javax.mail.Flags;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;

public class ApplicableFlagCalculator {
    private final Iterable<MailboxMessage> mailboxMessages;

    private static Function<MailboxMessage, Flags> toFlags() {
        return new Function<MailboxMessage, Flags>(){

            public Flags apply(MailboxMessage mailboxMessage) {
                return mailboxMessage.createFlags();
            }
        };
    }

    public ApplicableFlagCalculator(Iterable<MailboxMessage> mailboxMessages) {
        Preconditions.checkNotNull(mailboxMessages);
        this.mailboxMessages = mailboxMessages;
    }

    public Flags computeApplicableFlags() {
        return ApplicableFlagBuilder.builder().add((Flags[])FluentIterable.from(this.mailboxMessages).transform(ApplicableFlagCalculator.toFlags()).toArray(Flags.class)).build();
    }
}

