/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import org.apache.james.mailbox.store.mail.model.Property;

public final class SimpleProperty
implements Property {
    private final String namespace;
    private final String localName;
    private final String value;

    public SimpleProperty(String namespace, String localName, String value) {
        this.namespace = namespace;
        this.localName = localName;
        this.value = value;
    }

    public SimpleProperty(Property property) {
        this(property.getNamespace(), property.getLocalName(), property.getValue());
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isNamed(String namespace, String localName) {
        return namespace.equals(this.namespace) && localName.equals(this.localName);
    }

    public boolean isInSpace(String namespace) {
        return this.namespace.equals(namespace);
    }

    public String toString() {
        return "SimpleProperty(namespace='" + this.namespace + "' localName='" + this.localName + "' value='" + this.value + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleProperty)) {
            return false;
        }
        SimpleProperty that = (SimpleProperty)o;
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.localName != null ? !this.localName.equals(that.localName) : that.localName != null) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.localName != null ? this.localName.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

